@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.ExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A property containing information about the blobs to be exported for an export job. This property is required for export jobs, but must not be specified for import jobs.
 * @property blobListBlobPath The relative URI to the block blob that contains the list of blob paths or blob path prefixes as defined above, beginning with the container name. If the blob is in root container, the URI must begin with $root.
 * @property blobPath A collection of blob-path strings.
 * @property blobPathPrefix A collection of blob-prefix strings.
 */
public data class ExportArgs(
    public val blobListBlobPath: Output<String>? = null,
    public val blobPath: Output<List<String>>? = null,
    public val blobPathPrefix: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.ExportArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.ExportArgs =
        com.pulumi.azurenative.importexport.inputs.ExportArgs.builder()
            .blobListBlobPath(blobListBlobPath?.applyValue({ args0 -> args0 }))
            .blobPath(blobPath?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .blobPathPrefix(blobPathPrefix?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ExportArgs].
 */
@PulumiTagMarker
public class ExportArgsBuilder internal constructor() {
    private var blobListBlobPath: Output<String>? = null

    private var blobPath: Output<List<String>>? = null

    private var blobPathPrefix: Output<List<String>>? = null

    /**
     * @param value The relative URI to the block blob that contains the list of blob paths or blob path prefixes as defined above, beginning with the container name. If the blob is in root container, the URI must begin with $root.
     */
    @JvmName("nsadgfkspevnixqu")
    public suspend fun blobListBlobPath(`value`: Output<String>) {
        this.blobListBlobPath = value
    }

    /**
     * @param value A collection of blob-path strings.
     */
    @JvmName("fedubhihioagrpnw")
    public suspend fun blobPath(`value`: Output<List<String>>) {
        this.blobPath = value
    }

    @JvmName("cbvnmeboovfiaukp")
    public suspend fun blobPath(vararg values: Output<String>) {
        this.blobPath = Output.all(values.asList())
    }

    /**
     * @param values A collection of blob-path strings.
     */
    @JvmName("rgdfmefrxmlvaalk")
    public suspend fun blobPath(values: List<Output<String>>) {
        this.blobPath = Output.all(values)
    }

    /**
     * @param value A collection of blob-prefix strings.
     */
    @JvmName("bmxsifuthpmbggcl")
    public suspend fun blobPathPrefix(`value`: Output<List<String>>) {
        this.blobPathPrefix = value
    }

    @JvmName("vsxnspgabdhposgp")
    public suspend fun blobPathPrefix(vararg values: Output<String>) {
        this.blobPathPrefix = Output.all(values.asList())
    }

    /**
     * @param values A collection of blob-prefix strings.
     */
    @JvmName("goftimtlhtgymksa")
    public suspend fun blobPathPrefix(values: List<Output<String>>) {
        this.blobPathPrefix = Output.all(values)
    }

    /**
     * @param value The relative URI to the block blob that contains the list of blob paths or blob path prefixes as defined above, beginning with the container name. If the blob is in root container, the URI must begin with $root.
     */
    @JvmName("hacdovhixcgpxsqb")
    public suspend fun blobListBlobPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobListBlobPath = mapped
    }

    /**
     * @param value A collection of blob-path strings.
     */
    @JvmName("ibditoomvxgwcpgs")
    public suspend fun blobPath(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPath = mapped
    }

    /**
     * @param values A collection of blob-path strings.
     */
    @JvmName("ohgkyvvftrhriwwn")
    public suspend fun blobPath(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobPath = mapped
    }

    /**
     * @param value A collection of blob-prefix strings.
     */
    @JvmName("kmttbrvdhganvqfe")
    public suspend fun blobPathPrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobPathPrefix = mapped
    }

    /**
     * @param values A collection of blob-prefix strings.
     */
    @JvmName("dhjkpvbdtkvawpcs")
    public suspend fun blobPathPrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobPathPrefix = mapped
    }

    internal fun build(): ExportArgs = ExportArgs(
        blobListBlobPath = blobListBlobPath,
        blobPath = blobPath,
        blobPathPrefix = blobPathPrefix,
    )
}
