@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.AlertRuleArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.RuleEmailActionArgs
import com.pulumi.azurenative.insights.kotlin.inputs.RuleWebhookActionArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The alert rule resource.
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Example Usage
 * ### Create or update an alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alertRule = new AzureNative.Insights.AlertRule("alertRule", new()
 *     {
 *         Actions = new[] {},
 *         Condition = new AzureNative.Insights.Inputs.ThresholdRuleConditionArgs
 *         {
 *             DataSource = new AzureNative.Insights.Inputs.RuleMetricDataSourceArgs
 *             {
 *                 MetricName = "Requests",
 *                 OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource",
 *                 ResourceUri = "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest",
 *             },
 *             OdataType = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition",
 *             Operator = AzureNative.Insights.ConditionOperator.GreaterThan,
 *             Threshold = 3,
 *             TimeAggregation = AzureNative.Insights.TimeAggregationOperator.Total,
 *             WindowSize = "PT5M",
 *         },
 *         Description = "Pura Vida",
 *         IsEnabled = true,
 *         Location = "West US",
 *         Name = "chiricutin",
 *         ResourceGroupName = "Rac46PostSwapRG",
 *         RuleName = "chiricutin",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAlertRule(ctx, "alertRule", &insights.AlertRuleArgs{
 * 			Actions: pulumi.Array{},
 * 			Condition: insights.ThresholdRuleCondition{
 * 				DataSource: insights.RuleMetricDataSource{
 * 					MetricName:  "Requests",
 * 					OdataType:   "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource",
 * 					ResourceUri: "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest",
 * 				},
 * 				OdataType:       "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition",
 * 				Operator:        insights.ConditionOperatorGreaterThan,
 * 				Threshold:       3,
 * 				TimeAggregation: insights.TimeAggregationOperatorTotal,
 * 				WindowSize:      "PT5M",
 * 			},
 * 			Description:       pulumi.String("Pura Vida"),
 * 			IsEnabled:         pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			Name:              pulumi.String("chiricutin"),
 * 			ResourceGroupName: pulumi.String("Rac46PostSwapRG"),
 * 			RuleName:          pulumi.String("chiricutin"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AlertRule;
 * import com.pulumi.azurenative.insights.AlertRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alertRule = new AlertRule("alertRule", AlertRuleArgs.builder()
 *             .actions()
 *             .condition(Map.ofEntries(
 *                 Map.entry("dataSource", Map.ofEntries(
 *                     Map.entry("metricName", "Requests"),
 *                     Map.entry("odataType", "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"),
 *                     Map.entry("resourceUri", "/subscriptions/b67f7fec-69fc-4974-9099-a26bd6ffeda3/resourceGroups/Rac46PostSwapRG/providers/Microsoft.Web/sites/leoalerttest")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("threshold", 3),
 *                 Map.entry("timeAggregation", "Total"),
 *                 Map.entry("windowSize", "PT5M")
 *             ))
 *             .description("Pura Vida")
 *             .isEnabled(true)
 *             .location("West US")
 *             .name("chiricutin")
 *             .resourceGroupName("Rac46PostSwapRG")
 *             .ruleName("chiricutin")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AlertRule chiricutin /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/alertrules/{ruleName}
 * ```
 * @property action action that is performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property actions the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
 * @property condition the condition that results in the alert rule being activated.
 * @property description the description of the alert rule that will be included in the alert email.
 * @property isEnabled the flag that indicates whether the alert rule is enabled.
 * @property location Resource location
 * @property name the name of the alert rule.
 * @property provisioningState the provisioning state.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The name of the rule.
 * @property tags Resource tags
 */
public data class AlertRuleArgs(
    public val action: Output<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>? = null,
    public val actions: Output<List<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>>? = null,
    public val condition: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.AlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.AlertRuleArgs =
        com.pulumi.azurenative.insights.AlertRuleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .condition(condition?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AlertRuleArgs].
 */
@PulumiTagMarker
public class AlertRuleArgsBuilder internal constructor() {
    private var action: Output<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>? = null

    private var actions: Output<List<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>>? = null

    private var condition: Output<Any>? = null

    private var description: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("xnfokfawdmokutic")
    public suspend fun action(`value`: Output<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>) {
        this.action = value
    }

    /**
     * @param value the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("sncbwfbitedasbyh")
    public suspend
    fun actions(`value`: Output<List<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>>) {
        this.actions = value
    }

    @JvmName("lqpkfbuvuyqhvrjr")
    public suspend fun actions(
        vararg
        values: Output<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>,
    ) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("cpxavahcsjjgvrcd")
    public suspend
    fun actions(values: List<Output<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value the condition that results in the alert rule being activated.
     */
    @JvmName("ycrmhsrmtrtkygbq")
    public suspend fun condition(`value`: Output<Any>) {
        this.condition = value
    }

    /**
     * @param value the description of the alert rule that will be included in the alert email.
     */
    @JvmName("xxwgmfsefgyaavtw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value the flag that indicates whether the alert rule is enabled.
     */
    @JvmName("vlkjgcdoagqpxhqb")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("qbhovbxtyhlbhjun")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value the name of the alert rule.
     */
    @JvmName("fbuagrxpptiutjvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value the provisioning state.
     */
    @JvmName("ehgqgvvcnamuerwc")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hoxciijnmpdeohck")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("ksvwpvwthqyqcbvg")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("gmbbleupffydqhkt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("bqhjmyqkrntdqjux")
    public suspend fun action(`value`: Either<RuleEmailActionArgs, RuleWebhookActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("mfbqjfmuslhukblv")
    public fun action(`value`: RuleEmailActionArgs) {
        val toBeMapped = Either.ofLeft<RuleEmailActionArgs, RuleWebhookActionArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("gttfygmmgdckitow")
    public fun action(`value`: RuleWebhookActionArgs) {
        val toBeMapped = Either.ofRight<RuleEmailActionArgs, RuleWebhookActionArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("gnhbrikwvwqeoedx")
    public suspend fun actions(`value`: List<Either<RuleEmailActionArgs, RuleWebhookActionArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    @JvmName("wrxylcixwbsmhcwa")
    public suspend fun actions(vararg values: Either<RuleEmailActionArgs, RuleWebhookActionArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value the condition that results in the alert rule being activated.
     */
    @JvmName("utaqdilsnuncyrup")
    public suspend fun condition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value the description of the alert rule that will be included in the alert email.
     */
    @JvmName("iijfmrdufqwlqyyu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value the flag that indicates whether the alert rule is enabled.
     */
    @JvmName("yylgnpcgsjqeugrg")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("hksmamrngirdbesq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value the name of the alert rule.
     */
    @JvmName("mqdwixjiqbkvcxir")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value the provisioning state.
     */
    @JvmName("pdvammauemwlfyyj")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mxyboymqirjshnqi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("houhgbaarmjpeusx")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xsajotyfmylxopom")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("mqkqhodrhixsnfht")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AlertRuleArgs = AlertRuleArgs(
        action = action,
        actions = actions,
        condition = condition,
        description = description,
        isEnabled = isEnabled,
        location = location,
        name = name,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        tags = tags,
    )
}
