@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentAnalyticsItemPropertiesResponse
import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentAnalyticsItemPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AnalyticsItem].
 */
@PulumiTagMarker
public class AnalyticsItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalyticsItemArgs = AnalyticsItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalyticsItemArgsBuilder.() -> Unit) {
        val builder = AnalyticsItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnalyticsItem {
        val builtJavaResource = com.pulumi.azurenative.insights.AnalyticsItem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AnalyticsItem(builtJavaResource)
    }
}

/**
 * Properties that define an Analytics item that is associated to an Application Insights component.
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### AnalyticsItemPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var analyticsItem = new AzureNative.Insights.AnalyticsItem("analyticsItem", new()
 *     {
 *         Content = @"let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * ",
 *         Name = "Exceptions - New in the last 24 hours",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         Scope = "shared",
 *         ScopePath = "analyticsItems",
 *         Type = "query",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAnalyticsItem(ctx, "analyticsItem", &insights.AnalyticsItemArgs{
 * 			Content: pulumi.String(`let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * `),
 * 			Name:              pulumi.String("Exceptions - New in the last 24 hours"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			Scope:             pulumi.String("shared"),
 * 			ScopePath:         pulumi.String("analyticsItems"),
 * 			Type:              pulumi.String("query"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AnalyticsItem;
 * import com.pulumi.azurenative.insights.AnalyticsItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var analyticsItem = new AnalyticsItem("analyticsItem", AnalyticsItemArgs.builder()
 *             .content("""
 * let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 *             """)
 *             .name("Exceptions - New in the last 24 hours")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .scope("shared")
 *             .scopePath("analyticsItems")
 *             .type("query")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AnalyticsItem myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item
 * ```
 */
public class AnalyticsItem internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.AnalyticsItem,
) : KotlinCustomResource(javaResource, AnalyticsItemMapper) {
    /**
     * The content of this item
     */
    public val content: Output<String>?
        get() = javaResource.content().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user-defined name of the item.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
     */
    public val properties: Output<ApplicationInsightsComponentAnalyticsItemPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date and time in UTC when this item was created.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Date and time in UTC of the last modification that was made to this item.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * Enum indicating the type of the Analytics item.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This instance's version of the data model. This can change as new features are added.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object AnalyticsItemMapper : ResourceMapper<AnalyticsItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.AnalyticsItem::class == javaResource::class

    override fun map(javaResource: Resource): AnalyticsItem = AnalyticsItem(
        javaResource as
            com.pulumi.azurenative.insights.AnalyticsItem,
    )
}

/**
 * @see [AnalyticsItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnalyticsItem].
 */
public suspend fun analyticsItem(
    name: String,
    block: suspend AnalyticsItemResourceBuilder.() -> Unit,
): AnalyticsItem {
    val builder = AnalyticsItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnalyticsItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analyticsItem(name: String): AnalyticsItem {
    val builder = AnalyticsItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
