@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.AnalyticsItemArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ItemScope
import com.pulumi.azurenative.insights.kotlin.enums.ItemType
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentAnalyticsItemPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties that define an Analytics item that is associated to an Application Insights component.
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### AnalyticsItemPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var analyticsItem = new AzureNative.Insights.AnalyticsItem("analyticsItem", new()
 *     {
 *         Content = @"let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * ",
 *         Name = "Exceptions - New in the last 24 hours",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         Scope = "shared",
 *         ScopePath = "analyticsItems",
 *         Type = "query",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewAnalyticsItem(ctx, "analyticsItem", &insights.AnalyticsItemArgs{
 * 			Content: pulumi.String(`let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * `),
 * 			Name:              pulumi.String("Exceptions - New in the last 24 hours"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			Scope:             pulumi.String("shared"),
 * 			ScopePath:         pulumi.String("analyticsItems"),
 * 			Type:              pulumi.String("query"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.AnalyticsItem;
 * import com.pulumi.azurenative.insights.AnalyticsItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var analyticsItem = new AnalyticsItem("analyticsItem", AnalyticsItemArgs.builder()
 *             .content("""
 * let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 *             """)
 *             .name("Exceptions - New in the last 24 hours")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .scope("shared")
 *             .scopePath("analyticsItems")
 *             .type("query")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:AnalyticsItem myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item
 * ```
 * @property content The content of this item
 * @property id Internally assigned unique id of the item definition.
 * @property name The user-defined name of the item.
 * @property overrideItem Flag indicating whether or not to force save an item. This allows overriding an item if it already exists.
 * @property properties A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property scope Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 * @property scopePath Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 * @property type Enum indicating the type of the Analytics item.
 */
public data class AnalyticsItemArgs(
    public val content: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val overrideItem: Output<Boolean>? = null,
    public val properties: Output<ApplicationInsightsComponentAnalyticsItemPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val scope: Output<Either<String, ItemScope>>? = null,
    public val scopePath: Output<String>? = null,
    public val type: Output<Either<String, ItemType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.AnalyticsItemArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.AnalyticsItemArgs =
        com.pulumi.azurenative.insights.AnalyticsItemArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .overrideItem(overrideItem?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .scope(
                scope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scopePath(scopePath?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalyticsItemArgs].
 */
@PulumiTagMarker
public class AnalyticsItemArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var overrideItem: Output<Boolean>? = null

    private var properties: Output<ApplicationInsightsComponentAnalyticsItemPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var scope: Output<Either<String, ItemScope>>? = null

    private var scopePath: Output<String>? = null

    private var type: Output<Either<String, ItemType>>? = null

    /**
     * @param value The content of this item
     */
    @JvmName("asjirqthrabfesbb")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Internally assigned unique id of the item definition.
     */
    @JvmName("jawhmtjvwwipnbyy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The user-defined name of the item.
     */
    @JvmName("qaqnwdltayswfjte")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Flag indicating whether or not to force save an item. This allows overriding an item if it already exists.
     */
    @JvmName("gjcdnxpfujdqdmtd")
    public suspend fun overrideItem(`value`: Output<Boolean>) {
        this.overrideItem = value
    }

    /**
     * @param value A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
     */
    @JvmName("xrqumkccevotwbbv")
    public suspend
    fun properties(`value`: Output<ApplicationInsightsComponentAnalyticsItemPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nudgpskyedsitlih")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("yfojncialqkmpoyc")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("nwnlvcdqjfisqxup")
    public suspend fun scope(`value`: Output<Either<String, ItemScope>>) {
        this.scope = value
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("wrnnxpuawxgnqwae")
    public suspend fun scopePath(`value`: Output<String>) {
        this.scopePath = value
    }

    /**
     * @param value Enum indicating the type of the Analytics item.
     */
    @JvmName("byubheikkwfajjlc")
    public suspend fun type(`value`: Output<Either<String, ItemType>>) {
        this.type = value
    }

    /**
     * @param value The content of this item
     */
    @JvmName("yieimpdvtfnpeugx")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Internally assigned unique id of the item definition.
     */
    @JvmName("rlcghjtdekjvqnef")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The user-defined name of the item.
     */
    @JvmName("synknwyggptrskhh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Flag indicating whether or not to force save an item. This allows overriding an item if it already exists.
     */
    @JvmName("trsirxpnyjfnrtbj")
    public suspend fun overrideItem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideItem = mapped
    }

    /**
     * @param value A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
     */
    @JvmName("odbyvkjlctngiwse")
    public suspend fun properties(`value`: ApplicationInsightsComponentAnalyticsItemPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
     */
    @JvmName("cjixobrnqumtkyfh")
    public suspend
    fun properties(argument: suspend ApplicationInsightsComponentAnalyticsItemPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationInsightsComponentAnalyticsItemPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbojsiwfbqqpkpsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("ajwmjvkktpgkwtmf")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("viaucwapqkcfhjdt")
    public suspend fun scope(`value`: Either<String, ItemScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("taklbmmxdipwgovh")
    public fun scope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ItemScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("qgnjynecmtvaotmr")
    public fun scope(`value`: ItemScope) {
        val toBeMapped = Either.ofRight<String, ItemScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     */
    @JvmName("sgccmdgbhibafutd")
    public suspend fun scopePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopePath = mapped
    }

    /**
     * @param value Enum indicating the type of the Analytics item.
     */
    @JvmName("nbvyaajtggjxpsbq")
    public suspend fun type(`value`: Either<String, ItemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Enum indicating the type of the Analytics item.
     */
    @JvmName("wcfdgsetlgwgiwnt")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Enum indicating the type of the Analytics item.
     */
    @JvmName("pxfxyuahadqqfmjv")
    public fun type(`value`: ItemType) {
        val toBeMapped = Either.ofRight<String, ItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AnalyticsItemArgs = AnalyticsItemArgs(
        content = content,
        id = id,
        name = name,
        overrideItem = overrideItem,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        scope = scope,
        scopePath = scopePath,
        type = type,
    )
}
