@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentDataVolumeCapResponse
import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentDataVolumeCapResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ComponentCurrentBillingFeature].
 */
@PulumiTagMarker
public class ComponentCurrentBillingFeatureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComponentCurrentBillingFeatureArgs = ComponentCurrentBillingFeatureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComponentCurrentBillingFeatureArgsBuilder.() -> Unit) {
        val builder = ComponentCurrentBillingFeatureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ComponentCurrentBillingFeature {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ComponentCurrentBillingFeature(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ComponentCurrentBillingFeature(builtJavaResource)
    }
}

/**
 * An Application Insights component billing features
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### ComponentCurrentBillingFeaturesUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var componentCurrentBillingFeature = new AzureNative.Insights.ComponentCurrentBillingFeature("componentCurrentBillingFeature", new()
 *     {
 *         CurrentBillingFeatures = new[]
 *         {
 *             "Basic",
 *             "Application Insights Enterprise",
 *         },
 *         DataVolumeCap = new AzureNative.Insights.Inputs.ApplicationInsightsComponentDataVolumeCapArgs
 *         {
 *             Cap = 100,
 *             StopSendNotificationWhenHitCap = true,
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponentCurrentBillingFeature(ctx, "componentCurrentBillingFeature", &insights.ComponentCurrentBillingFeatureArgs{
 * 			CurrentBillingFeatures: pulumi.StringArray{
 * 				pulumi.String("Basic"),
 * 				pulumi.String("Application Insights Enterprise"),
 * 			},
 * 			DataVolumeCap: &insights.ApplicationInsightsComponentDataVolumeCapArgs{
 * 				Cap:                            pulumi.Float64(100),
 * 				StopSendNotificationWhenHitCap: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ComponentCurrentBillingFeature;
 * import com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var componentCurrentBillingFeature = new ComponentCurrentBillingFeature("componentCurrentBillingFeature", ComponentCurrentBillingFeatureArgs.builder()
 *             .currentBillingFeatures(
 *                 "Basic",
 *                 "Application Insights Enterprise")
 *             .dataVolumeCap(Map.ofEntries(
 *                 Map.entry("cap", 100),
 *                 Map.entry("stopSendNotificationWhenHitCap", true)
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ComponentCurrentBillingFeature myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures
 * ```
 */
public class ComponentCurrentBillingFeature internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ComponentCurrentBillingFeature,
) : KotlinCustomResource(javaResource, ComponentCurrentBillingFeatureMapper) {
    /**
     * Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
     */
    public val currentBillingFeatures: Output<List<String>>?
        get() = javaResource.currentBillingFeatures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * An Application Insights component daily data volume cap
     */
    public val dataVolumeCap: Output<ApplicationInsightsComponentDataVolumeCapResponse>?
        get() = javaResource.dataVolumeCap().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object ComponentCurrentBillingFeatureMapper : ResourceMapper<ComponentCurrentBillingFeature> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ComponentCurrentBillingFeature::class == javaResource::class

    override fun map(javaResource: Resource): ComponentCurrentBillingFeature =
        ComponentCurrentBillingFeature(
            javaResource as
                com.pulumi.azurenative.insights.ComponentCurrentBillingFeature,
        )
}

/**
 * @see [ComponentCurrentBillingFeature].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ComponentCurrentBillingFeature].
 */
public suspend fun componentCurrentBillingFeature(
    name: String,
    block: suspend ComponentCurrentBillingFeatureResourceBuilder.() -> Unit,
):
    ComponentCurrentBillingFeature {
    val builder = ComponentCurrentBillingFeatureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ComponentCurrentBillingFeature].
 * @param name The _unique_ name of the resulting resource.
 */
public fun componentCurrentBillingFeature(name: String): ComponentCurrentBillingFeature {
    val builder = ComponentCurrentBillingFeatureResourceBuilder()
    builder.name(name)
    return builder.build()
}
