@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentDataVolumeCapArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ApplicationInsightsComponentDataVolumeCapArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Application Insights component billing features
 * Azure REST API version: 2015-05-01. Prior API version in Azure Native 1.x: 2015-05-01.
 * ## Example Usage
 * ### ComponentCurrentBillingFeaturesUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var componentCurrentBillingFeature = new AzureNative.Insights.ComponentCurrentBillingFeature("componentCurrentBillingFeature", new()
 *     {
 *         CurrentBillingFeatures = new[]
 *         {
 *             "Basic",
 *             "Application Insights Enterprise",
 *         },
 *         DataVolumeCap = new AzureNative.Insights.Inputs.ApplicationInsightsComponentDataVolumeCapArgs
 *         {
 *             Cap = 100,
 *             StopSendNotificationWhenHitCap = true,
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponentCurrentBillingFeature(ctx, "componentCurrentBillingFeature", &insights.ComponentCurrentBillingFeatureArgs{
 * 			CurrentBillingFeatures: pulumi.StringArray{
 * 				pulumi.String("Basic"),
 * 				pulumi.String("Application Insights Enterprise"),
 * 			},
 * 			DataVolumeCap: &insights.ApplicationInsightsComponentDataVolumeCapArgs{
 * 				Cap:                            pulumi.Float64(100),
 * 				StopSendNotificationWhenHitCap: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ComponentCurrentBillingFeature;
 * import com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var componentCurrentBillingFeature = new ComponentCurrentBillingFeature("componentCurrentBillingFeature", ComponentCurrentBillingFeatureArgs.builder()
 *             .currentBillingFeatures(
 *                 "Basic",
 *                 "Application Insights Enterprise")
 *             .dataVolumeCap(Map.ofEntries(
 *                 Map.entry("cap", 100),
 *                 Map.entry("stopSendNotificationWhenHitCap", true)
 *             ))
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ComponentCurrentBillingFeature myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures
 * ```
 * @property currentBillingFeatures Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
 * @property dataVolumeCap An Application Insights component daily data volume cap
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 */
public data class ComponentCurrentBillingFeatureArgs(
    public val currentBillingFeatures: Output<List<String>>? = null,
    public val dataVolumeCap: Output<ApplicationInsightsComponentDataVolumeCapArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs =
        com.pulumi.azurenative.insights.ComponentCurrentBillingFeatureArgs.builder()
            .currentBillingFeatures(
                currentBillingFeatures?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dataVolumeCap(dataVolumeCap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentCurrentBillingFeatureArgs].
 */
@PulumiTagMarker
public class ComponentCurrentBillingFeatureArgsBuilder internal constructor() {
    private var currentBillingFeatures: Output<List<String>>? = null

    private var dataVolumeCap: Output<ApplicationInsightsComponentDataVolumeCapArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
     */
    @JvmName("supdsqsxvklwyfrd")
    public suspend fun currentBillingFeatures(`value`: Output<List<String>>) {
        this.currentBillingFeatures = value
    }

    @JvmName("ymlnotvfjcmkbxxj")
    public suspend fun currentBillingFeatures(vararg values: Output<String>) {
        this.currentBillingFeatures = Output.all(values.asList())
    }

    /**
     * @param values Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
     */
    @JvmName("tmmyvusvjclhqnjk")
    public suspend fun currentBillingFeatures(values: List<Output<String>>) {
        this.currentBillingFeatures = Output.all(values)
    }

    /**
     * @param value An Application Insights component daily data volume cap
     */
    @JvmName("oygmbvjyicotxxvi")
    public suspend fun dataVolumeCap(`value`: Output<ApplicationInsightsComponentDataVolumeCapArgs>) {
        this.dataVolumeCap = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("scdaychugmmclyet")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("ryxxwiaucxpceuhm")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
     */
    @JvmName("vqoyrifagewguoob")
    public suspend fun currentBillingFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentBillingFeatures = mapped
    }

    /**
     * @param values Current enabled pricing plan. When the component is in the Enterprise plan, this will list both 'Basic' and 'Application Insights Enterprise'.
     */
    @JvmName("ihdyeywbnhqjygpw")
    public suspend fun currentBillingFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currentBillingFeatures = mapped
    }

    /**
     * @param value An Application Insights component daily data volume cap
     */
    @JvmName("jcbfyjewshgiyyrp")
    public suspend fun dataVolumeCap(`value`: ApplicationInsightsComponentDataVolumeCapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataVolumeCap = mapped
    }

    /**
     * @param argument An Application Insights component daily data volume cap
     */
    @JvmName("flnapamrhwnsmhue")
    public suspend
    fun dataVolumeCap(argument: suspend ApplicationInsightsComponentDataVolumeCapArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationInsightsComponentDataVolumeCapArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataVolumeCap = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hvxvfbotjbuyhacy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("ecrsrljwjfdbpcvn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ComponentCurrentBillingFeatureArgs = ComponentCurrentBillingFeatureArgs(
        currentBillingFeatures = currentBillingFeatures,
        dataVolumeCap = dataVolumeCap,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
