@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.MetricAlertActionResponse
import com.pulumi.azurenative.insights.kotlin.outputs.MetricAlertActionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [MetricAlert].
 */
@PulumiTagMarker
public class MetricAlertResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricAlertArgs = MetricAlertArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricAlertArgsBuilder.() -> Unit) {
        val builder = MetricAlertArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MetricAlert {
        val builtJavaResource = com.pulumi.azurenative.insights.MetricAlert(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetricAlert(builtJavaResource)
    }
}

/**
 * The metric alert resource.
 * Azure REST API version: 2018-03-01. Prior API version in Azure Native 1.x: 2018-03-01.
 * ## Example Usage
 * ### Create or update a dynamic alert rule for Multiple Resources
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.DynamicMetricCriteriaArgs
 *                 {
 *                     AlertSensitivity = "Medium",
 *                     CriterionType = "DynamicThresholdCriterion",
 *                     Dimensions = new() { },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.DynamicThresholdFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 4,
 *                         NumberOfEvaluationPeriods = 4,
 *                     },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterOrLessThan",
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleResources",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.DynamicMetricCriteria{
 * 						AlertSensitivity: "Medium",
 * 						CriterionType:    "DynamicThresholdCriterion",
 * 						Dimensions:       []insights.MetricDimension{},
 * 						FailingPeriods: insights.DynamicThresholdFailingPeriods{
 * 							MinFailingPeriodsToAlert:  4,
 * 							NumberOfEvaluationPeriods: 4,
 * 						},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterOrLessThan",
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleResources"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("alertSensitivity", "Medium"),
 *                     Map.entry("criterionType", "DynamicThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("failingPeriods", Map.ofEntries(
 *                         Map.entry("minFailingPeriodsToAlert", 4),
 *                         Map.entry("numberOfEvaluationPeriods", 4)
 *                     )),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterOrLessThan"),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleResources")
 *             .scopes(
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a dynamic alert rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.DynamicMetricCriteriaArgs
 *                 {
 *                     AlertSensitivity = "Medium",
 *                     CriterionType = "DynamicThresholdCriterion",
 *                     Dimensions = new() { },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.DynamicThresholdFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 4,
 *                         NumberOfEvaluationPeriods = 4,
 *                     },
 *                     IgnoreDataBefore = "2019-04-04T21:00:00.000Z",
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterOrLessThan",
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "chiricutin",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.DynamicMetricCriteria{
 * 						AlertSensitivity: "Medium",
 * 						CriterionType:    "DynamicThresholdCriterion",
 * 						Dimensions:       []insights.MetricDimension{},
 * 						FailingPeriods: insights.DynamicThresholdFailingPeriods{
 * 							MinFailingPeriodsToAlert:  4,
 * 							NumberOfEvaluationPeriods: 4,
 * 						},
 * 						IgnoreDataBefore: "2019-04-04T21:00:00.000Z",
 * 						MetricName:       "Percentage CPU",
 * 						MetricNamespace:  "microsoft.compute/virtualmachines",
 * 						Name:             "High_CPU_80",
 * 						Operator:         "GreaterOrLessThan",
 * 						TimeAggregation:  "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("chiricutin"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("alertSensitivity", "Medium"),
 *                     Map.entry("criterionType", "DynamicThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("failingPeriods", Map.ofEntries(
 *                         Map.entry("minFailingPeriodsToAlert", 4),
 *                         Map.entry("numberOfEvaluationPeriods", 4)
 *                     )),
 *                     Map.entry("ignoreDataBefore", "2019-04-04T21:00:00.000Z"),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterOrLessThan"),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("chiricutin")
 *             .scopes("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")
 *             .severity(3)
 *             .tags()
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a web test alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[] {},
 *         Criteria = new AzureNative.Insights.Inputs.WebtestLocationAvailabilityCriteriaArgs
 *         {
 *             ComponentId = "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 *             FailedLocationCount = 2,
 *             OdataType = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria",
 *             WebTestId = "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *         },
 *         Description = "Automatically created alert rule for availability test \"component-example\" a",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "rg-example",
 *         RuleName = "webtest-name-example",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *             "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 *         },
 *         Severity = 4,
 *         Tags =
 *         {
 *             { "hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example", "Resource" },
 *             { "hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example", "Resource" },
 *         },
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: insights.MetricAlertActionArray{},
 * 			Criteria: insights.WebtestLocationAvailabilityCriteria{
 * 				ComponentId:         "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example",
 * 				FailedLocationCount: 2,
 * 				OdataType:           "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria",
 * 				WebTestId:           "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 * 			},
 * 			Description:         pulumi.String("Automatically created alert rule for availability test \"component-example\" a"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("rg-example"),
 * 			RuleName:            pulumi.String("webtest-name-example"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example"),
 * 				pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example"),
 * 			},
 * 			Severity: pulumi.Int(4),
 * 			Tags: pulumi.StringMap{
 * 				"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example": pulumi.String("Resource"),
 * 				"hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example":      pulumi.String("Resource"),
 * 			},
 * 			WindowSize: pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions()
 *             .criteria(Map.ofEntries(
 *                 Map.entry("componentId", "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example"),
 *                 Map.entry("failedLocationCount", 2),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"),
 *                 Map.entry("webTestId", "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example")
 *             ))
 *             .description("Automatically created alert rule for availability test \"component-example\" a")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("rg-example")
 *             .ruleName("webtest-name-example")
 *             .scopes(
 *                 "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example",
 *                 "/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example")
 *             .severity(4)
 *             .tags(Map.ofEntries(
 *                 Map.entry("hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/components/webtest-name-example", "Resource"),
 *                 Map.entry("hidden-link:/subscriptions/12345678-1234-1234-1234-123456789101/resourcegroups/rg-example/providers/microsoft.insights/webtests/component-example", "Resource")
 *             ))
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule for Multiple Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleResources",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleResources"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1"),
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleResources")
 *             .scopes(
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme1",
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertSingleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "\\Processor(_Total)\\% Processor Time",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "Pt1m",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "chiricutin",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "Pt15m",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertSingleResourceMultipleMetricCriteria{
 * 				AllOf: []insights.MetricCriteria{
 * 					{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "\\Processor(_Total)\\% Processor Time",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("Pt1m"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("chiricutin"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("Pt15m"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "\\Processor(_Total)\\% Processor Time"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("Pt1m")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("chiricutin")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme")
 *             .severity(3)
 *             .tags()
 *             .windowSize("Pt15m")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule on Resource group(s)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest1",
 *         RuleName = "MetricAlertAtResourceGroupLevel",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1",
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest1"),
 * 			RuleName:            pulumi.String("MetricAlertAtResourceGroupLevel"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1"),
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest1")
 *             .ruleName("MetricAlertAtResourceGroupLevel")
 *             .scopes(
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1",
 *                 "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rule on Subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new() { },
 *                     MetricName = "Percentage CPU",
 *                     MetricNamespace = "microsoft.compute/virtualmachines",
 *                     Name = "High_CPU_80",
 *                     Operator = "GreaterThan",
 *                     Threshold = 80.5,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1M",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertAtSubscriptionLevel",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         TargetResourceRegion = "southcentralus",
 *         TargetResourceType = "Microsoft.Compute/virtualMachines",
 *         WindowSize = "PT15M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType:   "StaticThresholdCriterion",
 * 						Dimensions:      []insights.MetricDimension{},
 * 						MetricName:      "Percentage CPU",
 * 						MetricNamespace: "microsoft.compute/virtualmachines",
 * 						Name:            "High_CPU_80",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       80.5,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1M"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertAtSubscriptionLevel"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7"),
 * 			},
 * 			Severity:             pulumi.Int(3),
 * 			Tags:                 nil,
 * 			TargetResourceRegion: pulumi.String("southcentralus"),
 * 			TargetResourceType:   pulumi.String("Microsoft.Compute/virtualMachines"),
 * 			WindowSize:           pulumi.String("PT15M"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions", ),
 *                     Map.entry("metricName", "Percentage CPU"),
 *                     Map.entry("metricNamespace", "microsoft.compute/virtualmachines"),
 *                     Map.entry("name", "High_CPU_80"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 80.5),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1M")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertAtSubscriptionLevel")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7")
 *             .severity(3)
 *             .tags()
 *             .targetResourceRegion("southcentralus")
 *             .targetResourceType("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT15M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an alert rules with dimensions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricAlert = new AzureNative.Insights.MetricAlert("metricAlert", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Insights.Inputs.MetricAlertActionArgs
 *             {
 *                 ActionGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
 *                 WebHookProperties =
 *                 {
 *                     { "key11", "value11" },
 *                     { "key12", "value12" },
 *                 },
 *             },
 *         },
 *         AutoMitigate = true,
 *         Criteria = new AzureNative.Insights.Inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.MetricCriteriaArgs
 *                 {
 *                     CriterionType = "StaticThresholdCriterion",
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.MetricDimensionArgs
 *                         {
 *                             Name = "ActivityName",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.MetricDimensionArgs
 *                         {
 *                             Name = "StatusCode",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "200",
 *                             },
 *                         },
 *                     },
 *                     MetricName = "Availability",
 *                     MetricNamespace = "Microsoft.KeyVault/vaults",
 *                     Name = "Metric1",
 *                     Operator = "GreaterThan",
 *                     Threshold = 55,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *             OdataType = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 *         },
 *         Description = "This is the description of the rule1",
 *         Enabled = true,
 *         EvaluationFrequency = "PT1H",
 *         Location = "global",
 *         ResourceGroupName = "gigtest",
 *         RuleName = "MetricAlertOnMultipleDimensions",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource",
 *         },
 *         Severity = 3,
 *         Tags = null,
 *         WindowSize = "P1D",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewMetricAlert(ctx, "metricAlert", &insights.MetricAlertArgs{
 * 			Actions: []insights.MetricAlertActionArgs{
 * 				{
 * 					ActionGroupId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 * 					WebHookProperties: {
 * 						"key11": pulumi.String("value11"),
 * 						"key12": pulumi.String("value12"),
 * 					},
 * 				},
 * 			},
 * 			AutoMitigate: pulumi.Bool(true),
 * 			Criteria: insights.MetricAlertMultipleResourceMultipleMetricCriteria{
 * 				AllOf: []interface{}{
 * 					insights.MetricCriteria{
 * 						CriterionType: "StaticThresholdCriterion",
 * 						Dimensions: []insights.MetricDimension{
 * 							{
 * 								Name:     "ActivityName",
 * 								Operator: "Include",
 * 								Values: []string{
 * 									"*",
 * 								},
 * 							},
 * 							{
 * 								Name:     "StatusCode",
 * 								Operator: "Include",
 * 								Values: []string{
 * 									"200",
 * 								},
 * 							},
 * 						},
 * 						MetricName:      "Availability",
 * 						MetricNamespace: "Microsoft.KeyVault/vaults",
 * 						Name:            "Metric1",
 * 						Operator:        "GreaterThan",
 * 						Threshold:       55,
 * 						TimeAggregation: "Average",
 * 					},
 * 				},
 * 				OdataType: "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
 * 			},
 * 			Description:         pulumi.String("This is the description of the rule1"),
 * 			Enabled:             pulumi.Bool(true),
 * 			EvaluationFrequency: pulumi.String("PT1H"),
 * 			Location:            pulumi.String("global"),
 * 			ResourceGroupName:   pulumi.String("gigtest"),
 * 			RuleName:            pulumi.String("MetricAlertOnMultipleDimensions"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource"),
 * 			},
 * 			Severity:   pulumi.Int(3),
 * 			Tags:       nil,
 * 			WindowSize: pulumi.String("P1D"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.MetricAlert;
 * import com.pulumi.azurenative.insights.MetricAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricAlert = new MetricAlert("metricAlert", MetricAlertArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
 *                 Map.entry("webHookProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .autoMitigate(true)
 *             .criteria(Map.ofEntries(
 *                 Map.entry("allOf", Map.ofEntries(
 *                     Map.entry("criterionType", "StaticThresholdCriterion"),
 *                     Map.entry("dimensions",
 *                         Map.ofEntries(
 *                             Map.entry("name", "ActivityName"),
 *                             Map.entry("operator", "Include"),
 *                             Map.entry("values", "*")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("name", "StatusCode"),
 *                             Map.entry("operator", "Include"),
 *                             Map.entry("values", "200")
 *                         )),
 *                     Map.entry("metricName", "Availability"),
 *                     Map.entry("metricNamespace", "Microsoft.KeyVault/vaults"),
 *                     Map.entry("name", "Metric1"),
 *                     Map.entry("operator", "GreaterThan"),
 *                     Map.entry("threshold", 55),
 *                     Map.entry("timeAggregation", "Average")
 *                 )),
 *                 Map.entry("odataType", "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria")
 *             ))
 *             .description("This is the description of the rule1")
 *             .enabled(true)
 *             .evaluationFrequency("PT1H")
 *             .location("global")
 *             .resourceGroupName("gigtest")
 *             .ruleName("MetricAlertOnMultipleDimensions")
 *             .scopes("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.KeyVault/vaults/keyVaultResource")
 *             .severity(3)
 *             .tags()
 *             .windowSize("P1D")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:MetricAlert webtest-name-example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}
 * ```
 */
public class MetricAlert internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.MetricAlert,
) : KotlinCustomResource(javaResource, MetricAlertMapper) {
    /**
     * the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    public val actions: Output<List<MetricAlertActionResponse>>?
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * the flag that indicates whether the alert should be auto resolved or not. The default is true.
     */
    public val autoMitigate: Output<Boolean>?
        get() = javaResource.autoMitigate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * defines the specific alert criteria information.
     */
    public val criteria: Output<Any>
        get() = javaResource.criteria().applyValue({ args0 -> args0 })

    /**
     * the description of the metric alert that will be included in the alert email.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the flag that indicates whether the metric alert is enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * how often the metric alert is evaluated represented in ISO 8601 duration format.
     */
    public val evaluationFrequency: Output<String>
        get() = javaResource.evaluationFrequency().applyValue({ args0 -> args0 })

    /**
     * the value indicating whether this alert rule is migrated.
     */
    public val isMigrated: Output<Boolean>
        get() = javaResource.isMigrated().applyValue({ args0 -> args0 })

    /**
     * Last time the rule was updated in ISO8601 format.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the list of resource id's that this metric alert is scoped to.
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Alert severity {0, 1, 2, 3, 4}
     */
    public val severity: Output<Int>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    public val targetResourceRegion: Output<String>?
        get() = javaResource.targetResourceRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     */
    public val targetResourceType: Output<String>?
        get() = javaResource.targetResourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     */
    public val windowSize: Output<String>
        get() = javaResource.windowSize().applyValue({ args0 -> args0 })
}

public object MetricAlertMapper : ResourceMapper<MetricAlert> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.MetricAlert::class == javaResource::class

    override fun map(javaResource: Resource): MetricAlert = MetricAlert(
        javaResource as
            com.pulumi.azurenative.insights.MetricAlert,
    )
}

/**
 * @see [MetricAlert].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricAlert].
 */
public suspend fun metricAlert(name: String, block: suspend MetricAlertResourceBuilder.() -> Unit):
    MetricAlert {
    val builder = MetricAlertResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricAlert].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricAlert(name: String): MetricAlert {
    val builder = MetricAlertResourceBuilder()
    builder.name(name)
    return builder.build()
}
