@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.MyWorkbookArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.Kind
import com.pulumi.azurenative.insights.kotlin.inputs.MyWorkbookManagedIdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.MyWorkbookManagedIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Application Insights private workbook definition.
 * Azure REST API version: 2021-03-08. Prior API version in Azure Native 1.x: 2020-10-20.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:MyWorkbook deadb33f-8bee-4d3b-a059-9be8dac93960 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}
 * ```
 * @property category Workbook category, as defined by the user at creation time.
 * @property displayName The user-defined name of the private workbook.
 * @property id Azure resource Id
 * @property identity Identity used for BYOS
 * @property kind The kind of workbook. Choices are user and shared.
 * @property location Resource location
 * @property name Azure resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property serializedData Configuration of this particular private workbook. Configuration data is a string containing valid JSON
 * @property sourceId Optional resourceId for a source resource.
 * @property storageUri BYOS Storage Account URI
 * @property tags Resource tags
 * @property type Azure resource type
 * @property version This instance's version of the data model. This can change as new features are added that can be marked private workbook.
 */
public data class MyWorkbookArgs(
    public val category: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<MyWorkbookManagedIdentityArgs>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val serializedData: Output<String>? = null,
    public val sourceId: Output<String>? = null,
    public val storageUri: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.MyWorkbookArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.MyWorkbookArgs =
        com.pulumi.azurenative.insights.MyWorkbookArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .serializedData(serializedData?.applyValue({ args0 -> args0 }))
            .sourceId(sourceId?.applyValue({ args0 -> args0 }))
            .storageUri(storageUri?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MyWorkbookArgs].
 */
@PulumiTagMarker
public class MyWorkbookArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<MyWorkbookManagedIdentityArgs>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var serializedData: Output<String>? = null

    private var sourceId: Output<String>? = null

    private var storageUri: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Workbook category, as defined by the user at creation time.
     */
    @JvmName("rfkavmoenuarhleb")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The user-defined name of the private workbook.
     */
    @JvmName("fslhoaukivfategs")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Azure resource Id
     */
    @JvmName("vvaxkniejsgeaqlv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Identity used for BYOS
     */
    @JvmName("nhbjboikvivtgpnj")
    public suspend fun identity(`value`: Output<MyWorkbookManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("jrxprahshcfhxdxm")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("cvlgonllftussqrh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource name
     */
    @JvmName("gcnkqxpfxpvodqgr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qyjhogldpaolonky")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("btplddlsonhqeegu")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Configuration of this particular private workbook. Configuration data is a string containing valid JSON
     */
    @JvmName("wbltrcshqjanuhwb")
    public suspend fun serializedData(`value`: Output<String>) {
        this.serializedData = value
    }

    /**
     * @param value Optional resourceId for a source resource.
     */
    @JvmName("byfcbuhdbrwkolob")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value BYOS Storage Account URI
     */
    @JvmName("wqlittfusksfvueq")
    public suspend fun storageUri(`value`: Output<String>) {
        this.storageUri = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ntkmlvjythljorwo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure resource type
     */
    @JvmName("huwdfdktelvirlax")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value This instance's version of the data model. This can change as new features are added that can be marked private workbook.
     */
    @JvmName("jjrsdgobkgcolyfb")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Workbook category, as defined by the user at creation time.
     */
    @JvmName("wjtmwmqrfewfgtht")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The user-defined name of the private workbook.
     */
    @JvmName("jprbpiybumpbvqho")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Azure resource Id
     */
    @JvmName("bqdeefqniwyqpfxy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Identity used for BYOS
     */
    @JvmName("ikevykfjpndyundl")
    public suspend fun identity(`value`: MyWorkbookManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity used for BYOS
     */
    @JvmName("emyhcswkunfbmnth")
    public suspend fun identity(argument: suspend MyWorkbookManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = MyWorkbookManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("oslvjkaxetdupeim")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("lqlscwjhuuporlfk")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("ltndkvhamrgdnoex")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("rwylqeeehmtcxrsc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource name
     */
    @JvmName("jpfmlcqtgwpbrygu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sshgqnkturtcdera")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("oewxaaqmywjwwqsg")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Configuration of this particular private workbook. Configuration data is a string containing valid JSON
     */
    @JvmName("hpddeghvhqpvcadx")
    public suspend fun serializedData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializedData = mapped
    }

    /**
     * @param value Optional resourceId for a source resource.
     */
    @JvmName("aqnflstyxssdnwks")
    public suspend fun sourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    /**
     * @param value BYOS Storage Account URI
     */
    @JvmName("xxknangkakjnrmwx")
    public suspend fun storageUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageUri = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ujhwohgkjbfvdwpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ysatxwwumkgihvld")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Azure resource type
     */
    @JvmName("fsrxexahscwbjbwv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value This instance's version of the data model. This can change as new features are added that can be marked private workbook.
     */
    @JvmName("kgngdukpcwhgsbcl")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): MyWorkbookArgs = MyWorkbookArgs(
        category = category,
        displayName = displayName,
        id = id,
        identity = identity,
        kind = kind,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        serializedData = serializedData,
        sourceId = sourceId,
        storageUri = storageUri,
        tags = tags,
        type = type,
        version = version,
    )
}
