@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrivateLinkScopedResource].
 */
@PulumiTagMarker
public class PrivateLinkScopedResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkScopedResourceArgs = PrivateLinkScopedResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateLinkScopedResourceArgsBuilder.() -> Unit) {
        val builder = PrivateLinkScopedResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateLinkScopedResource {
        val builtJavaResource =
            com.pulumi.azurenative.insights.PrivateLinkScopedResource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkScopedResource(builtJavaResource)
    }
}

/**
 * A private link scoped resource
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * ## Example Usage
 * ### Update a scoped resource in a private link scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScopedResource = new AzureNative.Insights.PrivateLinkScopedResource("privateLinkScopedResource", new()
 *     {
 *         LinkedResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component",
 *         Name = "scoped-resource-name",
 *         ResourceGroupName = "MyResourceGroup",
 *         ScopeName = "MyPrivateLinkScope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScopedResource(ctx, "privateLinkScopedResource", &insights.PrivateLinkScopedResourceArgs{
 * 			LinkedResourceId:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component"),
 * 			Name:              pulumi.String("scoped-resource-name"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			ScopeName:         pulumi.String("MyPrivateLinkScope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScopedResource;
 * import com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScopedResource = new PrivateLinkScopedResource("privateLinkScopedResource", PrivateLinkScopedResourceArgs.builder()
 *             .linkedResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component")
 *             .name("scoped-resource-name")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopeName("MyPrivateLinkScope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:PrivateLinkScopedResource scoped-resource-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/scopedResources/{name}
 * ```
 */
public class PrivateLinkScopedResource internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.PrivateLinkScopedResource,
) : KotlinCustomResource(javaResource, PrivateLinkScopedResourceMapper) {
    /**
     * The resource id of the scoped Azure monitor resource.
     */
    public val linkedResourceId: Output<String>?
        get() = javaResource.linkedResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the private endpoint connection.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * System data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkScopedResourceMapper : ResourceMapper<PrivateLinkScopedResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.PrivateLinkScopedResource::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkScopedResource =
        PrivateLinkScopedResource(
            javaResource as
                com.pulumi.azurenative.insights.PrivateLinkScopedResource,
        )
}

/**
 * @see [PrivateLinkScopedResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkScopedResource].
 */
public suspend fun privateLinkScopedResource(
    name: String,
    block: suspend PrivateLinkScopedResourceResourceBuilder.() -> Unit,
): PrivateLinkScopedResource {
    val builder = PrivateLinkScopedResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkScopedResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkScopedResource(name: String): PrivateLinkScopedResource {
    val builder = PrivateLinkScopedResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
