@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.Kind
import com.pulumi.azurenative.insights.kotlin.inputs.ActionsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ActionsArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.RuleResolveConfigurationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.RuleResolveConfigurationArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.ScheduledQueryRuleCriteriaArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ScheduledQueryRuleCriteriaArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The scheduled query rule resource.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2018-04-16.
 * Other available API versions: 2018-04-16, 2020-05-01-preview, 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a scheduled query rule for Single Resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "ComputerIp",
 *                             Operator = "Exclude",
 *                             Values = new[]
 *                             {
 *                                 "192.168.1.1",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "OSType",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     MetricMeasureColumn = "% Processor Time",
 *                     Operator = "GreaterThan",
 *                     Query = "Perf | where ObjectName == \"Processor\"",
 *                     ResourceIdColumn = "resourceId",
 *                     Threshold = 70,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *         },
 *         Description = "Performance rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "perf",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * &insights.DimensionArgs{
 * Name: pulumi.String("ComputerIp"),
 * Operator: pulumi.String("Exclude"),
 * Values: pulumi.StringArray{
 * pulumi.String("192.168.1.1"),
 * },
 * },
 * &insights.DimensionArgs{
 * Name: pulumi.String("OSType"),
 * Operator: pulumi.String("Include"),
 * Values: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * },
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * MetricMeasureColumn: pulumi.String("% Processor Time"),
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Perf | where ObjectName == \"Processor\""),
 * ResourceIdColumn: pulumi.String("resourceId"),
 * Threshold: pulumi.Float64(70),
 * TimeAggregation: pulumi.String("Average"),
 * },
 * },
 * },
 * Description: pulumi.String("Performance rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("perf"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ComputerIp"),
 *                         Map.entry("operator", "Exclude"),
 *                         Map.entry("values", "192.168.1.1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "OSType"),
 *                         Map.entry("operator", "Include"),
 *                         Map.entry("values", "*")
 *                     )),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("metricMeasureColumn", "% Processor Time"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Perf | where ObjectName == \"Processor\""),
 *                 Map.entry("resourceIdColumn", "resourceId"),
 *                 Map.entry("threshold", 70),
 *                 Map.entry("timeAggregation", "Average")
 *             )))
 *             .description("Performance rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("perf")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scheduled query rule on Resource group(s)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[] {},
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     Operator = "GreaterThan",
 *                     Query = "Heartbeat",
 *                     Threshold = 360,
 *                     TimeAggregation = "Count",
 *                 },
 *             },
 *         },
 *         Description = "Health check rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "heartbeat",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         TargetResourceTypes = new[]
 *         {
 *             "Microsoft.Compute/virtualMachines",
 *         },
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Heartbeat"),
 * Threshold: pulumi.Float64(360),
 * TimeAggregation: pulumi.String("Count"),
 * },
 * },
 * },
 * Description: pulumi.String("Health check rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("heartbeat"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * TargetResourceTypes: pulumi.StringArray{
 * pulumi.String("Microsoft.Compute/virtualMachines"),
 * },
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions", ),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Heartbeat"),
 *                 Map.entry("threshold", 360),
 *                 Map.entry("timeAggregation", "Count")
 *             )))
 *             .description("Health check rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("heartbeat")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .targetResourceTypes("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a scheduled query rule on Subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scheduledQueryRule = new AzureNative.Insights.ScheduledQueryRule("scheduledQueryRule", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionsArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup",
 *             },
 *             CustomProperties =
 *             {
 *                 { "key11", "value11" },
 *                 { "key12", "value12" },
 *             },
 *         },
 *         CheckWorkspaceAlertsStorageConfigured = true,
 *         Criteria = new AzureNative.Insights.Inputs.ScheduledQueryRuleCriteriaArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ConditionArgs
 *                 {
 *                     Dimensions = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "ComputerIp",
 *                             Operator = "Exclude",
 *                             Values = new[]
 *                             {
 *                                 "192.168.1.1",
 *                             },
 *                         },
 *                         new AzureNative.Insights.Inputs.DimensionArgs
 *                         {
 *                             Name = "OSType",
 *                             Operator = "Include",
 *                             Values = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                     FailingPeriods = new AzureNative.Insights.Inputs.ConditionFailingPeriodsArgs
 *                     {
 *                         MinFailingPeriodsToAlert = 1,
 *                         NumberOfEvaluationPeriods = 1,
 *                     },
 *                     MetricMeasureColumn = "% Processor Time",
 *                     Operator = "GreaterThan",
 *                     Query = "Perf | where ObjectName == \"Processor\"",
 *                     ResourceIdColumn = "resourceId",
 *                     Threshold = 70,
 *                     TimeAggregation = "Average",
 *                 },
 *             },
 *         },
 *         Description = "Performance rule",
 *         Enabled = true,
 *         EvaluationFrequency = "PT5M",
 *         Location = "eastus",
 *         MuteActionsDuration = "PT30M",
 *         ResourceGroupName = "QueryResourceGroupName",
 *         RuleName = "perf",
 *         RuleResolveConfiguration = new AzureNative.Insights.Inputs.RuleResolveConfigurationArgs
 *         {
 *             AutoResolved = true,
 *             TimeToResolve = "PT10M",
 *         },
 *         Scopes = new[]
 *         {
 *             "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147",
 *         },
 *         Severity = 4,
 *         SkipQueryValidation = true,
 *         TargetResourceTypes = new[]
 *         {
 *             "Microsoft.Compute/virtualMachines",
 *         },
 *         WindowSize = "PT10M",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewScheduledQueryRule(ctx, "scheduledQueryRule", &insights.ScheduledQueryRuleArgs{
 * Actions: &insights.ActionsArgs{
 * ActionGroups: pulumi.StringArray{
 * pulumi.String("/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 * },
 * CustomProperties: pulumi.StringMap{
 * "key11": pulumi.String("value11"),
 * "key12": pulumi.String("value12"),
 * },
 * },
 * CheckWorkspaceAlertsStorageConfigured: pulumi.Bool(true),
 * Criteria: insights.ScheduledQueryRuleCriteriaResponse{
 * AllOf: insights.ConditionArray{
 * interface{}{
 * Dimensions: insights.DimensionArray{
 * &insights.DimensionArgs{
 * Name: pulumi.String("ComputerIp"),
 * Operator: pulumi.String("Exclude"),
 * Values: pulumi.StringArray{
 * pulumi.String("192.168.1.1"),
 * },
 * },
 * &insights.DimensionArgs{
 * Name: pulumi.String("OSType"),
 * Operator: pulumi.String("Include"),
 * Values: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * },
 * },
 * FailingPeriods: &insights.ConditionFailingPeriodsArgs{
 * MinFailingPeriodsToAlert: pulumi.Float64(1),
 * NumberOfEvaluationPeriods: pulumi.Float64(1),
 * },
 * MetricMeasureColumn: pulumi.String("% Processor Time"),
 * Operator: pulumi.String("GreaterThan"),
 * Query: pulumi.String("Perf | where ObjectName == \"Processor\""),
 * ResourceIdColumn: pulumi.String("resourceId"),
 * Threshold: pulumi.Float64(70),
 * TimeAggregation: pulumi.String("Average"),
 * },
 * },
 * },
 * Description: pulumi.String("Performance rule"),
 * Enabled: pulumi.Bool(true),
 * EvaluationFrequency: pulumi.String("PT5M"),
 * Location: pulumi.String("eastus"),
 * MuteActionsDuration: pulumi.String("PT30M"),
 * ResourceGroupName: pulumi.String("QueryResourceGroupName"),
 * RuleName: pulumi.String("perf"),
 * RuleResolveConfiguration: &insights.RuleResolveConfigurationArgs{
 * AutoResolved: pulumi.Bool(true),
 * TimeToResolve: pulumi.String("PT10M"),
 * },
 * Scopes: pulumi.StringArray{
 * pulumi.String("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147"),
 * },
 * Severity: pulumi.Float64(4),
 * SkipQueryValidation: pulumi.Bool(true),
 * TargetResourceTypes: pulumi.StringArray{
 * pulumi.String("Microsoft.Compute/virtualMachines"),
 * },
 * WindowSize: pulumi.String("PT10M"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ScheduledQueryRule;
 * import com.pulumi.azurenative.insights.ScheduledQueryRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scheduledQueryRule = new ScheduledQueryRule("scheduledQueryRule", ScheduledQueryRuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("actionGroups", "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"),
 *                 Map.entry("customProperties", Map.ofEntries(
 *                     Map.entry("key11", "value11"),
 *                     Map.entry("key12", "value12")
 *                 ))
 *             ))
 *             .checkWorkspaceAlertsStorageConfigured(true)
 *             .criteria(Map.of("allOf", Map.ofEntries(
 *                 Map.entry("dimensions",
 *                     Map.ofEntries(
 *                         Map.entry("name", "ComputerIp"),
 *                         Map.entry("operator", "Exclude"),
 *                         Map.entry("values", "192.168.1.1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "OSType"),
 *                         Map.entry("operator", "Include"),
 *                         Map.entry("values", "*")
 *                     )),
 *                 Map.entry("failingPeriods", Map.ofEntries(
 *                     Map.entry("minFailingPeriodsToAlert", 1),
 *                     Map.entry("numberOfEvaluationPeriods", 1)
 *                 )),
 *                 Map.entry("metricMeasureColumn", "% Processor Time"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("query", "Perf | where ObjectName == \"Processor\""),
 *                 Map.entry("resourceIdColumn", "resourceId"),
 *                 Map.entry("threshold", 70),
 *                 Map.entry("timeAggregation", "Average")
 *             )))
 *             .description("Performance rule")
 *             .enabled(true)
 *             .evaluationFrequency("PT5M")
 *             .location("eastus")
 *             .muteActionsDuration("PT30M")
 *             .resourceGroupName("QueryResourceGroupName")
 *             .ruleName("perf")
 *             .ruleResolveConfiguration(Map.ofEntries(
 *                 Map.entry("autoResolved", true),
 *                 Map.entry("timeToResolve", "PT10M")
 *             ))
 *             .scopes("/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147")
 *             .severity(4)
 *             .skipQueryValidation(true)
 *             .targetResourceTypes("Microsoft.Compute/virtualMachines")
 *             .windowSize("PT10M")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ScheduledQueryRule perf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/scheduledQueryRules/{ruleName}
 * ```
 * @property actions Actions to invoke when the alert fires.
 * @property autoMitigate The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
 * @property checkWorkspaceAlertsStorageConfigured The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
 * @property criteria The rule criteria that defines the conditions of the scheduled query rule.
 * @property description The description of the scheduled query rule.
 * @property displayName The display name of the alert rule
 * @property enabled The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
 * @property evaluationFrequency How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
 * @property identity The identity of the resource.
 * @property kind Indicates the type of scheduled query rule. The default is LogAlert.
 * @property location The geo-location where the resource lives
 * @property muteActionsDuration Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
 * @property overrideQueryTimeRange If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName The name of the rule.
 * @property ruleResolveConfiguration Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
 * @property scopes The list of resource id's that this scheduled query rule is scoped to.
 * @property severity Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
 * @property skipQueryValidation The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
 * @property tags Resource tags.
 * @property targetResourceTypes List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
 * @property windowSize The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
 */
public data class ScheduledQueryRuleArgs(
    public val actions: Output<ActionsArgs>? = null,
    public val autoMitigate: Output<Boolean>? = null,
    public val checkWorkspaceAlertsStorageConfigured: Output<Boolean>? = null,
    public val criteria: Output<ScheduledQueryRuleCriteriaArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val evaluationFrequency: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val muteActionsDuration: Output<String>? = null,
    public val overrideQueryTimeRange: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleResolveConfiguration: Output<RuleResolveConfigurationArgs>? = null,
    public val scopes: Output<List<String>>? = null,
    public val severity: Output<Double>? = null,
    public val skipQueryValidation: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceTypes: Output<List<String>>? = null,
    public val windowSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ScheduledQueryRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ScheduledQueryRuleArgs =
        com.pulumi.azurenative.insights.ScheduledQueryRuleArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoMitigate(autoMitigate?.applyValue({ args0 -> args0 }))
            .checkWorkspaceAlertsStorageConfigured(
                checkWorkspaceAlertsStorageConfigured?.applyValue({ args0 ->
                    args0
                }),
            )
            .criteria(criteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .evaluationFrequency(evaluationFrequency?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .muteActionsDuration(muteActionsDuration?.applyValue({ args0 -> args0 }))
            .overrideQueryTimeRange(overrideQueryTimeRange?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleResolveConfiguration(
                ruleResolveConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .severity(severity?.applyValue({ args0 -> args0 }))
            .skipQueryValidation(skipQueryValidation?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceTypes(targetResourceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .windowSize(windowSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledQueryRuleArgs].
 */
@PulumiTagMarker
public class ScheduledQueryRuleArgsBuilder internal constructor() {
    private var actions: Output<ActionsArgs>? = null

    private var autoMitigate: Output<Boolean>? = null

    private var checkWorkspaceAlertsStorageConfigured: Output<Boolean>? = null

    private var criteria: Output<ScheduledQueryRuleCriteriaArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var evaluationFrequency: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var muteActionsDuration: Output<String>? = null

    private var overrideQueryTimeRange: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var ruleResolveConfiguration: Output<RuleResolveConfigurationArgs>? = null

    private var scopes: Output<List<String>>? = null

    private var severity: Output<Double>? = null

    private var skipQueryValidation: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceTypes: Output<List<String>>? = null

    private var windowSize: Output<String>? = null

    /**
     * @param value Actions to invoke when the alert fires.
     */
    @JvmName("kolpkxsictxpvdig")
    public suspend fun actions(`value`: Output<ActionsArgs>) {
        this.actions = value
    }

    /**
     * @param value The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("cdkkcmrmansprfcv")
    public suspend fun autoMitigate(`value`: Output<Boolean>) {
        this.autoMitigate = value
    }

    /**
     * @param value The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("meqdgbxqadutkcgh")
    public suspend fun checkWorkspaceAlertsStorageConfigured(`value`: Output<Boolean>) {
        this.checkWorkspaceAlertsStorageConfigured = value
    }

    /**
     * @param value The rule criteria that defines the conditions of the scheduled query rule.
     */
    @JvmName("jxaaxnwywrxqbwxl")
    public suspend fun criteria(`value`: Output<ScheduledQueryRuleCriteriaArgs>) {
        this.criteria = value
    }

    /**
     * @param value The description of the scheduled query rule.
     */
    @JvmName("oncveqpdanirqdyy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the alert rule
     */
    @JvmName("orlyccueycvckphr")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
     */
    @JvmName("jpqwnwvuadarkbid")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("tfulqoiubumydihk")
    public suspend fun evaluationFrequency(`value`: Output<String>) {
        this.evaluationFrequency = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("lsbtimrwfulmhcul")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Indicates the type of scheduled query rule. The default is LogAlert.
     */
    @JvmName("chjhxlcuavumposq")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rbkxmwonbhdmemkk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("vwyndapuplkumlhk")
    public suspend fun muteActionsDuration(`value`: Output<String>) {
        this.muteActionsDuration = value
    }

    /**
     * @param value If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
     */
    @JvmName("pbtcenjolbajxjvf")
    public suspend fun overrideQueryTimeRange(`value`: Output<String>) {
        this.overrideQueryTimeRange = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kcfccsknkigxaxlh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("llfdfcqibosklfuh")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("phsbmxxrmhprsbym")
    public suspend fun ruleResolveConfiguration(`value`: Output<RuleResolveConfigurationArgs>) {
        this.ruleResolveConfiguration = value
    }

    /**
     * @param value The list of resource id's that this scheduled query rule is scoped to.
     */
    @JvmName("dlwcgtppmfamawng")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("yclgwajqmkvxchqq")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values The list of resource id's that this scheduled query rule is scoped to.
     */
    @JvmName("vnnjqcbgsfbcgjqk")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("ivulwcnexvsptupn")
    public suspend fun severity(`value`: Output<Double>) {
        this.severity = value
    }

    /**
     * @param value The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("aycmaaogpbvrprew")
    public suspend fun skipQueryValidation(`value`: Output<Boolean>) {
        this.skipQueryValidation = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tsrkdylnjrplqqji")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
     */
    @JvmName("eodvioilqofisykw")
    public suspend fun targetResourceTypes(`value`: Output<List<String>>) {
        this.targetResourceTypes = value
    }

    @JvmName("imvymwrruajtavqi")
    public suspend fun targetResourceTypes(vararg values: Output<String>) {
        this.targetResourceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
     */
    @JvmName("pnddewqsqchxubgh")
    public suspend fun targetResourceTypes(values: List<Output<String>>) {
        this.targetResourceTypes = Output.all(values)
    }

    /**
     * @param value The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("nrtxyecwlcuwaaku")
    public suspend fun windowSize(`value`: Output<String>) {
        this.windowSize = value
    }

    /**
     * @param value Actions to invoke when the alert fires.
     */
    @JvmName("slgakjvkoeumxrmu")
    public suspend fun actions(`value`: ActionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Actions to invoke when the alert fires.
     */
    @JvmName("xsefuxrnpjgmhwhx")
    public suspend fun actions(argument: suspend ActionsArgsBuilder.() -> Unit) {
        val toBeMapped = ActionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("bfwfshxfoiknumqn")
    public suspend fun autoMitigate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMitigate = mapped
    }

    /**
     * @param value The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("wxdovhpguayjonvl")
    public suspend fun checkWorkspaceAlertsStorageConfigured(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkWorkspaceAlertsStorageConfigured = mapped
    }

    /**
     * @param value The rule criteria that defines the conditions of the scheduled query rule.
     */
    @JvmName("tbughssalmupelaa")
    public suspend fun criteria(`value`: ScheduledQueryRuleCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.criteria = mapped
    }

    /**
     * @param argument The rule criteria that defines the conditions of the scheduled query rule.
     */
    @JvmName("mbepgubflwivotpk")
    public suspend fun criteria(argument: suspend ScheduledQueryRuleCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduledQueryRuleCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.criteria = mapped
    }

    /**
     * @param value The description of the scheduled query rule.
     */
    @JvmName("woacavhhdccthlej")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the alert rule
     */
    @JvmName("ayeufymesuaqjnyi")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The flag which indicates whether this scheduled query rule is enabled. Value should be true or false
     */
    @JvmName("tcrtivbracjyodhl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("xwdkhpjhpysuojge")
    public suspend fun evaluationFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationFrequency = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("jtcmnvxkxdbxbihr")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("gmxlfhgxofnxmqfh")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Indicates the type of scheduled query rule. The default is LogAlert.
     */
    @JvmName("hettctrodlxnqusi")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of scheduled query rule. The default is LogAlert.
     */
    @JvmName("fojwiiuvtmnudwpq")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of scheduled query rule. The default is LogAlert.
     */
    @JvmName("spabecawntqimirf")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qslhjokrdtrhbplj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("dtnnlmjqemhkyiav")
    public suspend fun muteActionsDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.muteActionsDuration = mapped
    }

    /**
     * @param value If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
     */
    @JvmName("dqdltosivyoiuabn")
    public suspend fun overrideQueryTimeRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideQueryTimeRange = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("snpjtxlfgpoulsvi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("tnbnrytaeytwchpa")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("cvesckerooowvsxm")
    public suspend fun ruleResolveConfiguration(`value`: RuleResolveConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleResolveConfiguration = mapped
    }

    /**
     * @param argument Defines the configuration for resolving fired alerts. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("pedomrqvexvaivin")
    public suspend
    fun ruleResolveConfiguration(argument: suspend RuleResolveConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RuleResolveConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleResolveConfiguration = mapped
    }

    /**
     * @param value The list of resource id's that this scheduled query rule is scoped to.
     */
    @JvmName("kksuebuvcpqeheeh")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values The list of resource id's that this scheduled query rule is scoped to.
     */
    @JvmName("flhrofcwxnvknlmy")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("etispdoutdquvbby")
    public suspend fun severity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert.
     */
    @JvmName("hpcvwqihwuyqqybr")
    public suspend fun skipQueryValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipQueryValidation = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lraifhryugyonefx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nnxhrtdsconuhaki")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
     */
    @JvmName("wtguynqahdsjnthy")
    public suspend fun targetResourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceTypes = mapped
    }

    /**
     * @param values List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert
     */
    @JvmName("trpyxomcjhrdvqbo")
    public suspend fun targetResourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceTypes = mapped
    }

    /**
     * @param value The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
     */
    @JvmName("pufodgpjbwyoxnlt")
    public suspend fun windowSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowSize = mapped
    }

    internal fun build(): ScheduledQueryRuleArgs = ScheduledQueryRuleArgs(
        actions = actions,
        autoMitigate = autoMitigate,
        checkWorkspaceAlertsStorageConfigured = checkWorkspaceAlertsStorageConfigured,
        criteria = criteria,
        description = description,
        displayName = displayName,
        enabled = enabled,
        evaluationFrequency = evaluationFrequency,
        identity = identity,
        kind = kind,
        location = location,
        muteActionsDuration = muteActionsDuration,
        overrideQueryTimeRange = overrideQueryTimeRange,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        ruleResolveConfiguration = ruleResolveConfiguration,
        scopes = scopes,
        severity = severity,
        skipQueryValidation = skipQueryValidation,
        tags = tags,
        targetResourceTypes = targetResourceTypes,
        windowSize = windowSize,
    )
}
