@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.SubscriptionLogSettingsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.SubscriptionLogSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The subscription diagnostic setting resource.
 * Azure REST API version: 2021-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * Other available API versions: 2017-05-01-preview.
 * ## Example Usage
 * ### Creates or Updates the subscription diagnostic setting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionDiagnosticSetting = new AzureNative.Insights.SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SubscriptionLogSettingsArgs
 *             {
 *                 CategoryGroup = "allLogs",
 *                 Enabled = true,
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "ds4",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewSubscriptionDiagnosticSetting(ctx, "subscriptionDiagnosticSetting", &insights.SubscriptionDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.SubscriptionLogSettingsArgs{
 * 				{
 * 					CategoryGroup: pulumi.String("allLogs"),
 * 					Enabled:       pulumi.Bool(true),
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("ds4"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:          pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionDiagnosticSetting = new SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", SubscriptionDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("categoryGroup", "allLogs"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("ds4")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or Updates the subscription diagnostic setting for category
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionDiagnosticSetting = new AzureNative.Insights.SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", new()
 *     {
 *         EventHubAuthorizationRuleId = "/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule",
 *         EventHubName = "myeventhub",
 *         Logs = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SubscriptionLogSettingsArgs
 *             {
 *                 Category = "Security",
 *                 Enabled = true,
 *             },
 *         },
 *         MarketplacePartnerId = "/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1",
 *         Name = "ds4",
 *         StorageAccountId = "/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1",
 *         WorkspaceId = "",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewSubscriptionDiagnosticSetting(ctx, "subscriptionDiagnosticSetting", &insights.SubscriptionDiagnosticSettingArgs{
 * 			EventHubAuthorizationRuleId: pulumi.String("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule"),
 * 			EventHubName:                pulumi.String("myeventhub"),
 * 			Logs: []insights.SubscriptionLogSettingsArgs{
 * 				{
 * 					Category: pulumi.String("Security"),
 * 					Enabled:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			MarketplacePartnerId: pulumi.String("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1"),
 * 			Name:                 pulumi.String("ds4"),
 * 			StorageAccountId:     pulumi.String("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1"),
 * 			WorkspaceId:          pulumi.String(""),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSetting;
 * import com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionDiagnosticSetting = new SubscriptionDiagnosticSetting("subscriptionDiagnosticSetting", SubscriptionDiagnosticSettingArgs.builder()
 *             .eventHubAuthorizationRuleId("/subscriptions/fb9f25f9-5785-4510-a38f-a62f188eb9f8/resourceGroups/montest/providers/microsoft.eventhub/namespaces/mynamespace/authorizationrules/myrule")
 *             .eventHubName("myeventhub")
 *             .logs(Map.ofEntries(
 *                 Map.entry("category", "Security"),
 *                 Map.entry("enabled", true)
 *             ))
 *             .marketplacePartnerId("/subscriptions/abcdeabc-1234-1234-ab12-123a1234567a/resourceGroups/test-rg/providers/Microsoft.Datadog/monitors/dd1")
 *             .name("ds4")
 *             .storageAccountId("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/apptest/providers/Microsoft.Storage/storageAccounts/appteststorage1")
 *             .workspaceId("")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:SubscriptionDiagnosticSetting ds4 /subscriptions/{subscriptionId}/providers/Microsoft.Insights/diagnosticSettings/{name}
 * ```
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property logs The list of logs settings.
 * @property marketplacePartnerId The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
 * @property name The name of the diagnostic setting.
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property workspaceId The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class SubscriptionDiagnosticSettingArgs(
    public val eventHubAuthorizationRuleId: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val logs: Output<List<SubscriptionLogSettingsArgs>>? = null,
    public val marketplacePartnerId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serviceBusRuleId: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs =
        com.pulumi.azurenative.insights.SubscriptionDiagnosticSettingArgs.builder()
            .eventHubAuthorizationRuleId(eventHubAuthorizationRuleId?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .logs(logs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .marketplacePartnerId(marketplacePartnerId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceBusRuleId(serviceBusRuleId?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionDiagnosticSettingArgs].
 */
@PulumiTagMarker
public class SubscriptionDiagnosticSettingArgsBuilder internal constructor() {
    private var eventHubAuthorizationRuleId: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var logs: Output<List<SubscriptionLogSettingsArgs>>? = null

    private var marketplacePartnerId: Output<String>? = null

    private var name: Output<String>? = null

    private var serviceBusRuleId: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("sjvplpmqjvjsenox")
    public suspend fun eventHubAuthorizationRuleId(`value`: Output<String>) {
        this.eventHubAuthorizationRuleId = value
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("ngdpqifgrkyypnjr")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("tbxjsddmxrtfmoqp")
    public suspend fun logs(`value`: Output<List<SubscriptionLogSettingsArgs>>) {
        this.logs = value
    }

    @JvmName("nhuthdvlklqjeivo")
    public suspend fun logs(vararg values: Output<SubscriptionLogSettingsArgs>) {
        this.logs = Output.all(values.asList())
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("vfwlvdqshvgupcik")
    public suspend fun logs(values: List<Output<SubscriptionLogSettingsArgs>>) {
        this.logs = Output.all(values)
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("viemvmstyjijewrl")
    public suspend fun marketplacePartnerId(`value`: Output<String>) {
        this.marketplacePartnerId = value
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("frjnvnworjcodxgl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("tsbaucjdsiggxwlw")
    public suspend fun serviceBusRuleId(`value`: Output<String>) {
        this.serviceBusRuleId = value
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("bbythictvustmrxv")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("hdgmbyukklfjnusx")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The resource Id for the event hub authorization rule.
     */
    @JvmName("eqvwcfabwusfneox")
    public suspend fun eventHubAuthorizationRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubAuthorizationRuleId = mapped
    }

    /**
     * @param value The name of the event hub. If none is specified, the default event hub will be selected.
     */
    @JvmName("ffavdeedxqbkfelr")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The list of logs settings.
     */
    @JvmName("ovsvlppumetvolck")
    public suspend fun logs(`value`: List<SubscriptionLogSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("gobjhijacgwxfull")
    public suspend fun logs(argument: List<suspend SubscriptionLogSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubscriptionLogSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("tcscyftqmibduykm")
    public suspend fun logs(vararg argument: suspend SubscriptionLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SubscriptionLogSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param argument The list of logs settings.
     */
    @JvmName("tksngnkbiboqogha")
    public suspend fun logs(argument: suspend SubscriptionLogSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SubscriptionLogSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logs = mapped
    }

    /**
     * @param values The list of logs settings.
     */
    @JvmName("pvmhtpmxsctbkppc")
    public suspend fun logs(vararg values: SubscriptionLogSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logs = mapped
    }

    /**
     * @param value The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
     */
    @JvmName("dtsvbgwcbwvfrgaj")
    public suspend fun marketplacePartnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplacePartnerId = mapped
    }

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("cagkvylbukgplaot")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
     */
    @JvmName("mqfyxragmtooluas")
    public suspend fun serviceBusRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusRuleId = mapped
    }

    /**
     * @param value The resource ID of the storage account to which you would like to send Diagnostic Logs.
     */
    @JvmName("yydkqghwxomrxbhj")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
     */
    @JvmName("rrnqmiovyxltocuf")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): SubscriptionDiagnosticSettingArgs = SubscriptionDiagnosticSettingArgs(
        eventHubAuthorizationRuleId = eventHubAuthorizationRuleId,
        eventHubName = eventHubName,
        logs = logs,
        marketplacePartnerId = marketplacePartnerId,
        name = name,
        serviceBusRuleId = serviceBusRuleId,
        storageAccountId = storageAccountId,
        workspaceId = workspaceId,
    )
}
