@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum indicating if this favorite definition is owned by a specific user or is shared between all users with access to the Application Insights component.
 */
public enum class FavoriteType(
    public val javaValue: com.pulumi.azurenative.insights.enums.FavoriteType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.FavoriteType> {
    Shared(com.pulumi.azurenative.insights.enums.FavoriteType.Shared),
    User(com.pulumi.azurenative.insights.enums.FavoriteType.User),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.FavoriteType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.FavoriteType): FavoriteType =
            FavoriteType.values().first { it.javaValue == javaType }
    }
}
