@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
 */
public enum class FlowType(
    public val javaValue: com.pulumi.azurenative.insights.enums.FlowType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.FlowType> {
    Bluefield(com.pulumi.azurenative.insights.enums.FlowType.Bluefield),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.FlowType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.FlowType): FlowType =
            FlowType.values().first { it.javaValue == javaType }
    }
}
