@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.insights.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.IdentityType> {
    SystemAssigned(com.pulumi.azurenative.insights.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.insights.enums.IdentityType.UserAssigned),
    None(com.pulumi.azurenative.insights.enums.IdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.IdentityType): IdentityType =
            IdentityType.values().first { it.javaValue == javaType }
    }
}
