@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enum indicating the type of the Analytics item.
 */
public enum class ItemType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ItemType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ItemType> {
    None(com.pulumi.azurenative.insights.enums.ItemType.None),
    Query(com.pulumi.azurenative.insights.enums.ItemType.Query),
    Recent(com.pulumi.azurenative.insights.enums.ItemType.Recent),
    Function(com.pulumi.azurenative.insights.enums.ItemType.Function),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ItemType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ItemType): ItemType =
            ItemType.values().first { it.javaValue == javaType }
    }
}
