@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType> {
    None(com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ManagedServiceIdentityType):
            ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
