@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
 */
public enum class ScaleRuleMetricDimensionOperationType(
    public val javaValue: com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType> {
    Equals(com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType.Equals),
    NotEquals(com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType.NotEquals),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ScaleRuleMetricDimensionOperationType):
            ScaleRuleMetricDimensionOperationType =
            ScaleRuleMetricDimensionOperationType.values().first { it.javaValue == javaType }
    }
}
