@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static definitions of the ProactiveDetection configuration rule (same values for all components).
 * @property description The rule description
 * @property displayName The rule name as it is displayed in UI
 * @property helpUrl URL which displays additional info about the proactive detection rule
 * @property isEnabledByDefault A flag indicating whether the rule is enabled by default
 * @property isHidden A flag indicating whether the rule is hidden (from the UI)
 * @property isInPreview A flag indicating whether the rule is in preview
 * @property name The rule name
 * @property supportsEmailNotifications A flag indicating whether email notifications are supported for detections for this rule
 */
public data class
ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val helpUrl: Output<String>? = null,
    public val isEnabledByDefault: Output<Boolean>? = null,
    public val isHidden: Output<Boolean>? = null,
    public val isInPreview: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val supportsEmailNotifications: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs =
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .helpUrl(helpUrl?.applyValue({ args0 -> args0 }))
            .isEnabledByDefault(isEnabledByDefault?.applyValue({ args0 -> args0 }))
            .isHidden(isHidden?.applyValue({ args0 -> args0 }))
            .isInPreview(isInPreview?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .supportsEmailNotifications(supportsEmailNotifications?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs].
 */
@PulumiTagMarker
public class
ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgsBuilder
internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var helpUrl: Output<String>? = null

    private var isEnabledByDefault: Output<Boolean>? = null

    private var isHidden: Output<Boolean>? = null

    private var isInPreview: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var supportsEmailNotifications: Output<Boolean>? = null

    /**
     * @param value The rule description
     */
    @JvmName("nvlcpfleugvlpgbm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The rule name as it is displayed in UI
     */
    @JvmName("ajgfrpifqhmmxebr")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value URL which displays additional info about the proactive detection rule
     */
    @JvmName("brydfcqqloyiiepl")
    public suspend fun helpUrl(`value`: Output<String>) {
        this.helpUrl = value
    }

    /**
     * @param value A flag indicating whether the rule is enabled by default
     */
    @JvmName("hvsiqqxvlrmqvcce")
    public suspend fun isEnabledByDefault(`value`: Output<Boolean>) {
        this.isEnabledByDefault = value
    }

    /**
     * @param value A flag indicating whether the rule is hidden (from the UI)
     */
    @JvmName("hjaseesrehwpspwk")
    public suspend fun isHidden(`value`: Output<Boolean>) {
        this.isHidden = value
    }

    /**
     * @param value A flag indicating whether the rule is in preview
     */
    @JvmName("jtpxqmtxflvdqdip")
    public suspend fun isInPreview(`value`: Output<Boolean>) {
        this.isInPreview = value
    }

    /**
     * @param value The rule name
     */
    @JvmName("gtvxbidjctiberyw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A flag indicating whether email notifications are supported for detections for this rule
     */
    @JvmName("hculjevosshfsyfs")
    public suspend fun supportsEmailNotifications(`value`: Output<Boolean>) {
        this.supportsEmailNotifications = value
    }

    /**
     * @param value The rule description
     */
    @JvmName("mwoajkdjiajvwphq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The rule name as it is displayed in UI
     */
    @JvmName("lxieafonqyndvgfn")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value URL which displays additional info about the proactive detection rule
     */
    @JvmName("kdmhnkjxwuurrnih")
    public suspend fun helpUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helpUrl = mapped
    }

    /**
     * @param value A flag indicating whether the rule is enabled by default
     */
    @JvmName("ytnmbygcilwwyedj")
    public suspend fun isEnabledByDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabledByDefault = mapped
    }

    /**
     * @param value A flag indicating whether the rule is hidden (from the UI)
     */
    @JvmName("aloyjwctauyjrpjh")
    public suspend fun isHidden(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHidden = mapped
    }

    /**
     * @param value A flag indicating whether the rule is in preview
     */
    @JvmName("mobhcftpjmvqjwwi")
    public suspend fun isInPreview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isInPreview = mapped
    }

    /**
     * @param value The rule name
     */
    @JvmName("fdgrxwecwsqbhcsm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A flag indicating whether email notifications are supported for detections for this rule
     */
    @JvmName("ciicoyjouyeiqqhk")
    public suspend fun supportsEmailNotifications(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportsEmailNotifications = mapped
    }

    internal fun build():
        ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs =
        ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs(
            description = description,
            displayName = displayName,
            helpUrl = helpUrl,
            isEnabledByDefault = isEnabledByDefault,
            isHidden = isHidden,
            isInPreview = isInPreview,
            name = name,
            supportsEmailNotifications = supportsEmailNotifications,
        )
}
