@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DataCollectionEndpointResourceIdentityArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ManagedServiceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed service identity of the resource.
 * @property type Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 * @property userAssignedIdentities The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
 */
public data class DataCollectionEndpointResourceIdentityArgs(
    public val type: Output<Either<String, ManagedServiceIdentityType>>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DataCollectionEndpointResourceIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.DataCollectionEndpointResourceIdentityArgs =
        com.pulumi.azurenative.insights.inputs.DataCollectionEndpointResourceIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DataCollectionEndpointResourceIdentityArgs].
 */
@PulumiTagMarker
public class DataCollectionEndpointResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedServiceIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("viyskqnfswkibknu")
    public suspend fun type(`value`: Output<Either<String, ManagedServiceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("hrnfbjyrrqygtsmw")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("hqgysfqfltemcdpr")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("wmfupwqcqwrvosrh")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("daaqkfqrfsyubdav")
    public suspend fun type(`value`: Either<String, ManagedServiceIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("jnqlnwpsxkgxlndh")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
     */
    @JvmName("giqcboexwovjhams")
    public fun type(`value`: ManagedServiceIdentityType) {
        val toBeMapped = Either.ofRight<String, ManagedServiceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("gbsvlhneunsonbxw")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
     */
    @JvmName("gvqsgogqnwgiejkf")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): DataCollectionEndpointResourceIdentityArgs =
        DataCollectionEndpointResourceIdentityArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            userAssignedIdentities = userAssignedIdentities,
        )
}
