@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EventHubDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventHubResourceId The resource ID of the event hub.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class EventHubDestinationArgs(
    public val eventHubResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EventHubDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EventHubDestinationArgs =
        com.pulumi.azurenative.insights.inputs.EventHubDestinationArgs.builder()
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubDestinationArgs].
 */
@PulumiTagMarker
public class EventHubDestinationArgsBuilder internal constructor() {
    private var eventHubResourceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The resource ID of the event hub.
     */
    @JvmName("pduumijwevhsjbtu")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("ospeylspsngfbvba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the event hub.
     */
    @JvmName("liyicvesravsvkpp")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("yqnoptuskljqqlsd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventHubDestinationArgs = EventHubDestinationArgs(
        eventHubResourceId = eventHubResourceId,
        name = name,
    )
}
