@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EventHubDirectDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventHubResourceId The resource ID of the event hub.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class EventHubDirectDestinationArgs(
    public val eventHubResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EventHubDirectDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EventHubDirectDestinationArgs =
        com.pulumi.azurenative.insights.inputs.EventHubDirectDestinationArgs.builder()
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubDirectDestinationArgs].
 */
@PulumiTagMarker
public class EventHubDirectDestinationArgsBuilder internal constructor() {
    private var eventHubResourceId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The resource ID of the event hub.
     */
    @JvmName("xicjxnfcehfwrvea")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("bxcexnibuuvfihlx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the event hub.
     */
    @JvmName("ggxhetjwadqegmgr")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("rmwbivqeukbxuqee")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EventHubDirectDestinationArgs = EventHubDirectDestinationArgs(
        eventHubResourceId = eventHubResourceId,
        name = name,
    )
}
