@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Event hub receiver.
 * @property eventHubName The name of the specific Event Hub queue
 * @property eventHubNameSpace The Event Hub namespace
 * @property name The name of the Event hub receiver. Names must be unique across all receivers within an action group.
 * @property subscriptionId The Id for the subscription containing this event hub
 * @property tenantId The tenant Id for the subscription containing this event hub
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class EventHubReceiverArgs(
    public val eventHubName: Output<String>,
    public val eventHubNameSpace: Output<String>,
    public val name: Output<String>,
    public val subscriptionId: Output<String>,
    public val tenantId: Output<String>? = null,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs =
        com.pulumi.azurenative.insights.inputs.EventHubReceiverArgs.builder()
            .eventHubName(eventHubName.applyValue({ args0 -> args0 }))
            .eventHubNameSpace(eventHubNameSpace.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubReceiverArgs].
 */
@PulumiTagMarker
public class EventHubReceiverArgsBuilder internal constructor() {
    private var eventHubName: Output<String>? = null

    private var eventHubNameSpace: Output<String>? = null

    private var name: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value The name of the specific Event Hub queue
     */
    @JvmName("erpxtqoicyiosuqk")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The Event Hub namespace
     */
    @JvmName("hlujrewpeujsnmab")
    public suspend fun eventHubNameSpace(`value`: Output<String>) {
        this.eventHubNameSpace = value
    }

    /**
     * @param value The name of the Event hub receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("kcvfsgmasdhtqoqy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Id for the subscription containing this event hub
     */
    @JvmName("iaawijmcptmbquee")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The tenant Id for the subscription containing this event hub
     */
    @JvmName("tyqklobqcnthltkd")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("bfjudxnbufdxhfuv")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value The name of the specific Event Hub queue
     */
    @JvmName("oqrdyhwlpciclpth")
    public suspend fun eventHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The Event Hub namespace
     */
    @JvmName("spdqtrwxropnymkm")
    public suspend fun eventHubNameSpace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubNameSpace = mapped
    }

    /**
     * @param value The name of the Event hub receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("imvkowpfavpjpghg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Id for the subscription containing this event hub
     */
    @JvmName("xterrsjeigyevgru")
    public suspend fun subscriptionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The tenant Id for the subscription containing this event hub
     */
    @JvmName("tawbfjrxyomulcvs")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("wkdlybfyrxsabxsr")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): EventHubReceiverArgs = EventHubReceiverArgs(
        eventHubName = eventHubName ?: throw PulumiNullFieldException("eventHubName"),
        eventHubNameSpace = eventHubNameSpace ?: throw PulumiNullFieldException("eventHubNameSpace"),
        name = name ?: throw PulumiNullFieldException("name"),
        subscriptionId = subscriptionId ?: throw PulumiNullFieldException("subscriptionId"),
        tenantId = tenantId,
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
