@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetAutoscaleSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoscaleSettingName The autoscale setting name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAutoscaleSettingPlainArgs(
    public val autoscaleSettingName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetAutoscaleSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetAutoscaleSettingPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetAutoscaleSettingPlainArgs.builder()
            .autoscaleSettingName(autoscaleSettingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAutoscaleSettingPlainArgs].
 */
@PulumiTagMarker
public class GetAutoscaleSettingPlainArgsBuilder internal constructor() {
    private var autoscaleSettingName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The autoscale setting name.
     */
    @JvmName("baboefysajifpbhv")
    public suspend fun autoscaleSettingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.autoscaleSettingName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hvklrjtmmhmqgasw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAutoscaleSettingPlainArgs = GetAutoscaleSettingPlainArgs(
        autoscaleSettingName = autoscaleSettingName ?: throw
            PulumiNullFieldException("autoscaleSettingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
