@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetComponentLinkedStorageAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property storageType The type of the Application Insights component data source for the linked storage account.
 */
public data class GetComponentLinkedStorageAccountPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
    public val storageType: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetComponentLinkedStorageAccountPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.GetComponentLinkedStorageAccountPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetComponentLinkedStorageAccountPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .storageType(storageType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetComponentLinkedStorageAccountPlainArgs].
 */
@PulumiTagMarker
public class GetComponentLinkedStorageAccountPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var storageType: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hmignsvxffjnttef")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("mjstwqrjutqsumnl")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value The type of the Application Insights component data source for the linked storage account.
     */
    @JvmName("bqtjbclwqgfsluqx")
    public suspend fun storageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageType = mapped
    }

    internal fun build(): GetComponentLinkedStorageAccountPlainArgs =
        GetComponentLinkedStorageAccountPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            storageType = storageType ?: throw PulumiNullFieldException("storageType"),
        )
}
