@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetDataCollectionRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataCollectionRulePlainArgs(
    public val dataCollectionRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetDataCollectionRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetDataCollectionRulePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetDataCollectionRulePlainArgs.builder()
            .dataCollectionRuleName(dataCollectionRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataCollectionRulePlainArgs].
 */
@PulumiTagMarker
public class GetDataCollectionRulePlainArgsBuilder internal constructor() {
    private var dataCollectionRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the data collection rule. The name is case insensitive.
     */
    @JvmName("kqkundayyosmpwhe")
    public suspend fun dataCollectionRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataCollectionRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nvhkdjgxwfhxmaro")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataCollectionRulePlainArgs = GetDataCollectionRulePlainArgs(
        dataCollectionRuleName = dataCollectionRuleName ?: throw
            PulumiNullFieldException("dataCollectionRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
