@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diagnosticSettingsName The name of the diagnostic setting.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGuestDiagnosticsSettingPlainArgs(
    public val diagnosticSettingsName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetGuestDiagnosticsSettingPlainArgs.builder()
            .diagnosticSettingsName(diagnosticSettingsName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestDiagnosticsSettingPlainArgs].
 */
@PulumiTagMarker
public class GetGuestDiagnosticsSettingPlainArgsBuilder internal constructor() {
    private var diagnosticSettingsName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("ntyrggvrieqkrjdk")
    public suspend fun diagnosticSettingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diagnosticSettingsName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("awdgqpgqpnrisltf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGuestDiagnosticsSettingPlainArgs = GetGuestDiagnosticsSettingPlainArgs(
        diagnosticSettingsName = diagnosticSettingsName ?: throw
            PulumiNullFieldException("diagnosticSettingsName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
