@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetProactiveDetectionConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights component.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 */
public data class GetProactiveDetectionConfigurationPlainArgs(
    public val configurationId: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetProactiveDetectionConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.GetProactiveDetectionConfigurationPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetProactiveDetectionConfigurationPlainArgs.builder()
            .configurationId(configurationId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProactiveDetectionConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetProactiveDetectionConfigurationPlainArgsBuilder internal constructor() {
    private var configurationId: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The ProactiveDetection configuration ID. This is unique within a Application Insights component.
     */
    @JvmName("qmmnlirwqlasowbg")
    public suspend fun configurationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fntsekkgxcmssdis")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("kxefqatniusmrrfr")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetProactiveDetectionConfigurationPlainArgs =
        GetProactiveDetectionConfigurationPlainArgs(
            configurationId = configurationId ?: throw PulumiNullFieldException("configurationId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
