@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetSubscriptionDiagnosticSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the diagnostic setting.
 */
public data class GetSubscriptionDiagnosticSettingPlainArgs(
    public val name: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetSubscriptionDiagnosticSettingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.GetSubscriptionDiagnosticSettingPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetSubscriptionDiagnosticSettingPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscriptionDiagnosticSettingPlainArgs].
 */
@PulumiTagMarker
public class GetSubscriptionDiagnosticSettingPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value The name of the diagnostic setting.
     */
    @JvmName("gsxypgpwmapdhjao")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetSubscriptionDiagnosticSettingPlainArgs =
        GetSubscriptionDiagnosticSettingPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
