@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetTenantActionGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The management group id.
 * @property tenantActionGroupName The name of the action group.
 */
public data class GetTenantActionGroupPlainArgs(
    public val managementGroupId: String,
    public val tenantActionGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetTenantActionGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetTenantActionGroupPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetTenantActionGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .tenantActionGroupName(tenantActionGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTenantActionGroupPlainArgs].
 */
@PulumiTagMarker
public class GetTenantActionGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var tenantActionGroupName: String? = null

    /**
     * @param value The management group id.
     */
    @JvmName("pqvsgwhdiqijobul")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the action group.
     */
    @JvmName("wagiwbfknoflkova")
    public suspend fun tenantActionGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tenantActionGroupName = mapped
    }

    internal fun build(): GetTenantActionGroupPlainArgs = GetTenantActionGroupPlainArgs(
        managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
        tenantActionGroupName = tenantActionGroupName ?: throw
            PulumiNullFieldException("tenantActionGroupName"),
    )
}
