@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetWorkbookPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property canFetchContent Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content for workbooks.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource.
 */
public data class GetWorkbookPlainArgs(
    public val canFetchContent: Boolean? = null,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetWorkbookPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetWorkbookPlainArgs =
        com.pulumi.azurenative.insights.inputs.GetWorkbookPlainArgs.builder()
            .canFetchContent(canFetchContent?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkbookPlainArgs].
 */
@PulumiTagMarker
public class GetWorkbookPlainArgsBuilder internal constructor() {
    private var canFetchContent: Boolean? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content for workbooks.
     */
    @JvmName("uahohgymuhxaujtj")
    public suspend fun canFetchContent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.canFetchContent = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("esyebpqckxmetyip")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("xmomelhtttmjiwko")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetWorkbookPlainArgs = GetWorkbookPlainArgs(
        canFetchContent = canFetchContent,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
