@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
 * @property category Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
 * @property categoryGroup Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
 * @property enabled a value indicating whether this log is enabled.
 * @property retentionPolicy the retention policy for this log.
 */
public data class LogSettingsArgs(
    public val category: Output<String>? = null,
    public val categoryGroup: Output<String>? = null,
    public val enabled: Output<Boolean>,
    public val retentionPolicy: Output<RetentionPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogSettingsArgs =
        com.pulumi.azurenative.insights.inputs.LogSettingsArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .categoryGroup(categoryGroup?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .retentionPolicy(
                retentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LogSettingsArgs].
 */
@PulumiTagMarker
public class LogSettingsArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var categoryGroup: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var retentionPolicy: Output<RetentionPolicyArgs>? = null

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("mddwdjncvuqfkwhi")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("dpmffpcxlxqbnwqh")
    public suspend fun categoryGroup(`value`: Output<String>) {
        this.categoryGroup = value
    }

    /**
     * @param value a value indicating whether this log is enabled.
     */
    @JvmName("ivqvjmjuwosfqend")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value the retention policy for this log.
     */
    @JvmName("puyofvgypqmhosaf")
    public suspend fun retentionPolicy(`value`: Output<RetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("bjuptvwbkbylffhi")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of a Diagnostic Log category group for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
     */
    @JvmName("rjsyhgfhqiplvvdy")
    public suspend fun categoryGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categoryGroup = mapped
    }

    /**
     * @param value a value indicating whether this log is enabled.
     */
    @JvmName("iscllewyvrkfbbfx")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value the retention policy for this log.
     */
    @JvmName("apvkdpgjssyeblqv")
    public suspend fun retentionPolicy(`value`: RetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument the retention policy for this log.
     */
    @JvmName("udwgtjfocflrojvj")
    public suspend fun retentionPolicy(argument: suspend RetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    internal fun build(): LogSettingsArgs = LogSettingsArgs(
        category = category,
        categoryGroup = categoryGroup,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        retentionPolicy = retentionPolicy,
    )
}
