@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricAlertActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An alert action.
 * @property actionGroupId the id of the action group to use.
 * @property webHookProperties This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
 */
public data class MetricAlertActionArgs(
    public val actionGroupId: Output<String>? = null,
    public val webHookProperties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricAlertActionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricAlertActionArgs =
        com.pulumi.azurenative.insights.inputs.MetricAlertActionArgs.builder()
            .actionGroupId(actionGroupId?.applyValue({ args0 -> args0 }))
            .webHookProperties(
                webHookProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MetricAlertActionArgs].
 */
@PulumiTagMarker
public class MetricAlertActionArgsBuilder internal constructor() {
    private var actionGroupId: Output<String>? = null

    private var webHookProperties: Output<Map<String, String>>? = null

    /**
     * @param value the id of the action group to use.
     */
    @JvmName("tqpgoyeiykpgkitp")
    public suspend fun actionGroupId(`value`: Output<String>) {
        this.actionGroupId = value
    }

    /**
     * @param value This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
     */
    @JvmName("amorcxxuowdnacae")
    public suspend fun webHookProperties(`value`: Output<Map<String, String>>) {
        this.webHookProperties = value
    }

    /**
     * @param value the id of the action group to use.
     */
    @JvmName("mftqmclnbyjqwdiw")
    public suspend fun actionGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroupId = mapped
    }

    /**
     * @param value This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
     */
    @JvmName("lfwntaetuhhfrbtb")
    public suspend fun webHookProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webHookProperties = mapped
    }

    /**
     * @param values This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
     */
    @JvmName("wbhgqchrhgprrbjw")
    public fun webHookProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webHookProperties = mapped
    }

    internal fun build(): MetricAlertActionArgs = MetricAlertActionArgs(
        actionGroupId = actionGroupId,
        webHookProperties = webHookProperties,
    )
}
