@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricCriteriaArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.AggregationTypeEnum
import com.pulumi.azurenative.insights.kotlin.enums.Operator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Criterion to filter metrics.
 * @property criterionType Specifies the type of threshold criteria
 * Expected value is 'StaticThresholdCriterion'.
 * @property dimensions List of dimension conditions.
 * @property metricName Name of the metric.
 * @property metricNamespace Namespace of the metric.
 * @property name Name of the criteria.
 * @property operator the criteria operator.
 * @property skipMetricValidation Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
 * @property threshold the criteria threshold value that activates the alert.
 * @property timeAggregation the criteria time aggregation types.
 */
public data class MetricCriteriaArgs(
    public val criterionType: Output<String>,
    public val dimensions: Output<List<MetricDimensionArgs>>? = null,
    public val metricName: Output<String>,
    public val metricNamespace: Output<String>? = null,
    public val name: Output<String>,
    public val `operator`: Output<Either<String, Operator>>,
    public val skipMetricValidation: Output<Boolean>? = null,
    public val threshold: Output<Double>,
    public val timeAggregation: Output<Either<String, AggregationTypeEnum>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricCriteriaArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.MetricCriteriaArgs.builder()
            .criterionType(criterionType.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .skipMetricValidation(skipMetricValidation?.applyValue({ args0 -> args0 }))
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .timeAggregation(
                timeAggregation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MetricCriteriaArgs].
 */
@PulumiTagMarker
public class MetricCriteriaArgsBuilder internal constructor() {
    private var criterionType: Output<String>? = null

    private var dimensions: Output<List<MetricDimensionArgs>>? = null

    private var metricName: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, Operator>>? = null

    private var skipMetricValidation: Output<Boolean>? = null

    private var threshold: Output<Double>? = null

    private var timeAggregation: Output<Either<String, AggregationTypeEnum>>? = null

    /**
     * @param value Specifies the type of threshold criteria
     * Expected value is 'StaticThresholdCriterion'.
     */
    @JvmName("dgvstuhgkhmtasyv")
    public suspend fun criterionType(`value`: Output<String>) {
        this.criterionType = value
    }

    /**
     * @param value List of dimension conditions.
     */
    @JvmName("bamtveqmkcpnqtmm")
    public suspend fun dimensions(`value`: Output<List<MetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("wuwqjqglolynalrl")
    public suspend fun dimensions(vararg values: Output<MetricDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values List of dimension conditions.
     */
    @JvmName("wkqgduokrqijqdun")
    public suspend fun dimensions(values: List<Output<MetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("tqxsdywcunqdrxki")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("opvejbbopwmdnbyd")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value Name of the criteria.
     */
    @JvmName("irmnwmtdkwbajpag")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value the criteria operator.
     */
    @JvmName("lhwvyhjybdiuwhkx")
    public suspend fun `operator`(`value`: Output<Either<String, Operator>>) {
        this.`operator` = value
    }

    /**
     * @param value Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
     */
    @JvmName("evhtnakiogwnvdso")
    public suspend fun skipMetricValidation(`value`: Output<Boolean>) {
        this.skipMetricValidation = value
    }

    /**
     * @param value the criteria threshold value that activates the alert.
     */
    @JvmName("vqkbdledbjvoxhel")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("mmhvucsvowhprehn")
    public suspend fun timeAggregation(`value`: Output<Either<String, AggregationTypeEnum>>) {
        this.timeAggregation = value
    }

    /**
     * @param value Specifies the type of threshold criteria
     * Expected value is 'StaticThresholdCriterion'.
     */
    @JvmName("wpyjmnxpthelqpfp")
    public suspend fun criterionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.criterionType = mapped
    }

    /**
     * @param value List of dimension conditions.
     */
    @JvmName("cebpentdoudaqmhr")
    public suspend fun dimensions(`value`: List<MetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("wvjpejvvmfshjqna")
    public suspend fun dimensions(argument: List<suspend MetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("dkxhvuwithykkxow")
    public suspend fun dimensions(vararg argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions.
     */
    @JvmName("eidpfvjthwrcgqwi")
    public suspend fun dimensions(argument: suspend MetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricDimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values List of dimension conditions.
     */
    @JvmName("iogngjjyccrbrvgk")
    public suspend fun dimensions(vararg values: MetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("owpptmfngprkxcap")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("vmeysmhjoipbxujv")
    public suspend fun metricNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value Name of the criteria.
     */
    @JvmName("vveawsihxjrikijr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value the criteria operator.
     */
    @JvmName("xxuxjclmdyuawgwc")
    public suspend fun `operator`(`value`: Either<String, Operator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the criteria operator.
     */
    @JvmName("rteymnrrpphrdmgu")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the criteria operator.
     */
    @JvmName("smwlfquqqowsaodo")
    public fun `operator`(`value`: Operator) {
        val toBeMapped = Either.ofRight<String, Operator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
     */
    @JvmName("gfwofyxqmppbkisw")
    public suspend fun skipMetricValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipMetricValidation = mapped
    }

    /**
     * @param value the criteria threshold value that activates the alert.
     */
    @JvmName("udphyukijskmfegb")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("cfeyqxqynhmjwmlw")
    public suspend fun timeAggregation(`value`: Either<String, AggregationTypeEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("rkkbyvrahkmsnvev")
    public fun timeAggregation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AggregationTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the criteria time aggregation types.
     */
    @JvmName("hvvwenudriggluhw")
    public fun timeAggregation(`value`: AggregationTypeEnum) {
        val toBeMapped = Either.ofRight<String, AggregationTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    internal fun build(): MetricCriteriaArgs = MetricCriteriaArgs(
        criterionType = criterionType ?: throw PulumiNullFieldException("criterionType"),
        dimensions = dimensions,
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        metricNamespace = metricNamespace,
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        skipMetricValidation = skipMetricValidation,
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        timeAggregation = timeAggregation ?: throw PulumiNullFieldException("timeAggregation"),
    )
}
