@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MyWorkbookManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Customer Managed Identity
 * @property type The identity type.
 */
public data class MyWorkbookManagedIdentityArgs(
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MyWorkbookManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MyWorkbookManagedIdentityArgs =
        com.pulumi.azurenative.insights.inputs.MyWorkbookManagedIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MyWorkbookManagedIdentityArgs].
 */
@PulumiTagMarker
public class MyWorkbookManagedIdentityArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("kwlylurncgclgakb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("jucftbndqnjtakcq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MyWorkbookManagedIdentityArgs = MyWorkbookManagedIdentityArgs(
        type = type,
    )
}
