@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.PredictiveAutoscalePolicyArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.PredictiveAutoscalePolicyScaleMode
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters for enabling predictive autoscale.
 * @property scaleLookAheadTime the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
 * @property scaleMode the predictive autoscale mode
 */
public data class PredictiveAutoscalePolicyArgs(
    public val scaleLookAheadTime: Output<String>? = null,
    public val scaleMode: Output<PredictiveAutoscalePolicyScaleMode>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.PredictiveAutoscalePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.PredictiveAutoscalePolicyArgs =
        com.pulumi.azurenative.insights.inputs.PredictiveAutoscalePolicyArgs.builder()
            .scaleLookAheadTime(scaleLookAheadTime?.applyValue({ args0 -> args0 }))
            .scaleMode(scaleMode.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PredictiveAutoscalePolicyArgs].
 */
@PulumiTagMarker
public class PredictiveAutoscalePolicyArgsBuilder internal constructor() {
    private var scaleLookAheadTime: Output<String>? = null

    private var scaleMode: Output<PredictiveAutoscalePolicyScaleMode>? = null

    /**
     * @param value the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
     */
    @JvmName("mjfpkmuterjfocga")
    public suspend fun scaleLookAheadTime(`value`: Output<String>) {
        this.scaleLookAheadTime = value
    }

    /**
     * @param value the predictive autoscale mode
     */
    @JvmName("ssgfbfgdiccncxif")
    public suspend fun scaleMode(`value`: Output<PredictiveAutoscalePolicyScaleMode>) {
        this.scaleMode = value
    }

    /**
     * @param value the amount of time to specify by which instances are launched in advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
     */
    @JvmName("jvaeuioutnetcouo")
    public suspend fun scaleLookAheadTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleLookAheadTime = mapped
    }

    /**
     * @param value the predictive autoscale mode
     */
    @JvmName("bayenjajaqaeekiw")
    public suspend fun scaleMode(`value`: PredictiveAutoscalePolicyScaleMode) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleMode = mapped
    }

    internal fun build(): PredictiveAutoscalePolicyArgs = PredictiveAutoscalePolicyArgs(
        scaleLookAheadTime = scaleLookAheadTime,
        scaleMode = scaleMode ?: throw PulumiNullFieldException("scaleMode"),
    )
}
