@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the retention policy for the log.
 * @property days the number of days for the retention in days. A value of 0 will retain the events indefinitely.
 * @property enabled a value indicating whether the retention policy is enabled.
 */
public data class RetentionPolicyArgs(
    public val days: Output<Int>,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs =
        com.pulumi.azurenative.insights.inputs.RetentionPolicyArgs.builder()
            .days(days.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetentionPolicyArgs].
 */
@PulumiTagMarker
public class RetentionPolicyArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value the number of days for the retention in days. A value of 0 will retain the events indefinitely.
     */
    @JvmName("lxfkfqhjuxtnhhet")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value a value indicating whether the retention policy is enabled.
     */
    @JvmName("khxwdhcvbxciruol")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value the number of days for the retention in days. A value of 0 will retain the events indefinitely.
     */
    @JvmName("kayofuctdlaqxpsr")
    public suspend fun days(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value a value indicating whether the retention policy is enabled.
     */
    @JvmName("kdtptfixlswxeusl")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): RetentionPolicyArgs = RetentionPolicyArgs(
        days = days ?: throw PulumiNullFieldException("days"),
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
