@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.SmsReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An SMS receiver.
 * @property countryCode The country code of the SMS receiver.
 * @property name The name of the SMS receiver. Names must be unique across all receivers within a tenant action group.
 * @property phoneNumber The phone number of the SMS receiver.
 */
public data class SmsReceiverArgs(
    public val countryCode: Output<String>,
    public val name: Output<String>,
    public val phoneNumber: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.SmsReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.SmsReceiverArgs =
        com.pulumi.azurenative.insights.inputs.SmsReceiverArgs.builder()
            .countryCode(countryCode.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmsReceiverArgs].
 */
@PulumiTagMarker
public class SmsReceiverArgsBuilder internal constructor() {
    private var countryCode: Output<String>? = null

    private var name: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    /**
     * @param value The country code of the SMS receiver.
     */
    @JvmName("akssuhcjktjfwlyx")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The name of the SMS receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("kuuhjilsbcquysgd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The phone number of the SMS receiver.
     */
    @JvmName("fgpoejnlkjokwfos")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value The country code of the SMS receiver.
     */
    @JvmName("bdgrgoqlnbnuecmn")
    public suspend fun countryCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The name of the SMS receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("ldoulidaablneupk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The phone number of the SMS receiver.
     */
    @JvmName("qbmhovcdcqnmumvr")
    public suspend fun phoneNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): SmsReceiverArgs = SmsReceiverArgs(
        countryCode = countryCode ?: throw PulumiNullFieldException("countryCode"),
        name = name ?: throw PulumiNullFieldException("name"),
        phoneNumber = phoneNumber ?: throw PulumiNullFieldException("phoneNumber"),
    )
}
