@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.StorageTableDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property storageAccountResourceId The resource ID of the storage account.
 * @property tableName The name of the Storage Table.
 */
public data class StorageTableDestinationArgs(
    public val name: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.StorageTableDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.StorageTableDestinationArgs =
        com.pulumi.azurenative.insights.inputs.StorageTableDestinationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageTableDestinationArgs].
 */
@PulumiTagMarker
public class StorageTableDestinationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("xnlseafyvwarcmfh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource ID of the storage account.
     */
    @JvmName("mnfbayvjemymbcui")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value The name of the Storage Table.
     */
    @JvmName("csrsxfhmnrthiqug")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("ubrlwcfeyyudfttn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource ID of the storage account.
     */
    @JvmName("xaofatxfmtetoenx")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    /**
     * @param value The name of the Storage Table.
     */
    @JvmName("cbvxtkosmmlwtbwo")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): StorageTableDestinationArgs = StorageTableDestinationArgs(
        name = name,
        storageAccountResourceId = storageAccountResourceId,
        tableName = tableName,
    )
}
