@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.StreamDeclarationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Declaration of a custom stream.
 * @property columns List of columns used by data in this stream.
 */
public data class StreamDeclarationArgs(
    public val columns: Output<List<ColumnDefinitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.StreamDeclarationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.StreamDeclarationArgs =
        com.pulumi.azurenative.insights.inputs.StreamDeclarationArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamDeclarationArgs].
 */
@PulumiTagMarker
public class StreamDeclarationArgsBuilder internal constructor() {
    private var columns: Output<List<ColumnDefinitionArgs>>? = null

    /**
     * @param value List of columns used by data in this stream.
     */
    @JvmName("topstlmqpvavpaat")
    public suspend fun columns(`value`: Output<List<ColumnDefinitionArgs>>) {
        this.columns = value
    }

    @JvmName("vtltbwlhaknqvpax")
    public suspend fun columns(vararg values: Output<ColumnDefinitionArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values List of columns used by data in this stream.
     */
    @JvmName("jsjarcplhpfndcfk")
    public suspend fun columns(values: List<Output<ColumnDefinitionArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value List of columns used by data in this stream.
     */
    @JvmName("bakyladkhjldimll")
    public suspend fun columns(`value`: List<ColumnDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument List of columns used by data in this stream.
     */
    @JvmName("pypliqtfajlcoega")
    public suspend fun columns(argument: List<suspend ColumnDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ColumnDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of columns used by data in this stream.
     */
    @JvmName("skgucgvxeohidytc")
    public suspend fun columns(vararg argument: suspend ColumnDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ColumnDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument List of columns used by data in this stream.
     */
    @JvmName("shyapsjuuefqccrf")
    public suspend fun columns(argument: suspend ColumnDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ColumnDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values List of columns used by data in this stream.
     */
    @JvmName("dgdhalmqsolrnkjl")
    public suspend fun columns(vararg values: ColumnDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    internal fun build(): StreamDeclarationArgs = StreamDeclarationArgs(
        columns = columns,
    )
}
