@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.
 * @property location Location ID for the WebTest to run from.
 */
public data class WebTestGeolocationArgs(
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs =
        com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestGeolocationArgs].
 */
@PulumiTagMarker
public class WebTestGeolocationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    /**
     * @param value Location ID for the WebTest to run from.
     */
    @JvmName("wqfaxakjipmcwqgi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Location ID for the WebTest to run from.
     */
    @JvmName("dbifulkdcclfnsgc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): WebTestGeolocationArgs = WebTestGeolocationArgs(
        location = location,
    )
}
