@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An XML configuration specification for a WebTest.
 * @property webTest The XML specification of a WebTest to run against an application.
 */
public data class WebTestPropertiesConfigurationArgs(
    public val webTest: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs.builder()
            .webTest(webTest?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestPropertiesConfigurationArgs].
 */
@PulumiTagMarker
public class WebTestPropertiesConfigurationArgsBuilder internal constructor() {
    private var webTest: Output<String>? = null

    /**
     * @param value The XML specification of a WebTest to run against an application.
     */
    @JvmName("aksdyidybqkxkpgn")
    public suspend fun webTest(`value`: Output<String>) {
        this.webTest = value
    }

    /**
     * @param value The XML specification of a WebTest to run against an application.
     */
    @JvmName("rsyrwhmlqryadanc")
    public suspend fun webTest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webTest = mapped
    }

    internal fun build(): WebTestPropertiesConfigurationArgs = WebTestPropertiesConfigurationArgs(
        webTest = webTest,
    )
}
