@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WindowsFirewallLogsDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Enables Firewall logs to be collected by this data collection rule.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams Firewall logs streams
 */
public data class WindowsFirewallLogsDataSourceArgs(
    public val name: Output<String>? = null,
    public val streams: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WindowsFirewallLogsDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WindowsFirewallLogsDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.WindowsFirewallLogsDataSourceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(streams.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WindowsFirewallLogsDataSourceArgs].
 */
@PulumiTagMarker
public class WindowsFirewallLogsDataSourceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var streams: Output<List<String>>? = null

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("hwvyaflwmrgumuek")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Firewall logs streams
     */
    @JvmName("pfpbqqntaweymygr")
    public suspend fun streams(`value`: Output<List<String>>) {
        this.streams = value
    }

    @JvmName("yiamimyakrroghdt")
    public suspend fun streams(vararg values: Output<String>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values Firewall logs streams
     */
    @JvmName("lxavhevljxoucxji")
    public suspend fun streams(values: List<Output<String>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("fnfiribpyftpukjo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Firewall logs streams
     */
    @JvmName("bvwkhoavrmipbukg")
    public suspend fun streams(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values Firewall logs streams
     */
    @JvmName("nmdjwbvsjfcwwvwk")
    public suspend fun streams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): WindowsFirewallLogsDataSourceArgs = WindowsFirewallLogsDataSourceArgs(
        name = name,
        streams = streams ?: throw PulumiNullFieldException("streams"),
    )
}
