@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gallery information for a workbook template.
 * @property category Category for the gallery.
 * @property name Name of the workbook template in the gallery.
 * @property order Order of the template within the gallery.
 * @property resourceType Azure resource type supported by the gallery.
 * @property type Type of workbook supported by the workbook template.
 */
public data class WorkbookTemplateGalleryArgs(
    public val category: Output<String>? = null,
    public val name: Output<String>? = null,
    public val order: Output<Int>? = null,
    public val resourceType: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs =
        com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .order(order?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkbookTemplateGalleryArgs].
 */
@PulumiTagMarker
public class WorkbookTemplateGalleryArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var name: Output<String>? = null

    private var order: Output<Int>? = null

    private var resourceType: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Category for the gallery.
     */
    @JvmName("jlhywkigmammreip")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Name of the workbook template in the gallery.
     */
    @JvmName("jtrlyiuqkixpgpnn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Order of the template within the gallery.
     */
    @JvmName("kyrrwysoemuqmfri")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Azure resource type supported by the gallery.
     */
    @JvmName("eakoxisftcpntfyx")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Type of workbook supported by the workbook template.
     */
    @JvmName("qbnytlejykrxsxth")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Category for the gallery.
     */
    @JvmName("hcjmajnvjcbbucby")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of the workbook template in the gallery.
     */
    @JvmName("erxrwvibfcdfgata")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Order of the template within the gallery.
     */
    @JvmName("bhwxyycrcshkjhda")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Azure resource type supported by the gallery.
     */
    @JvmName("qxchdlqjhqprbpuy")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Type of workbook supported by the workbook template.
     */
    @JvmName("bkoneqkekfdmuwmx")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkbookTemplateGalleryArgs = WorkbookTemplateGalleryArgs(
        category = category,
        name = name,
        order = order,
        resourceType = resourceType,
        type = type,
    )
}
