@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
 * This condition must contain 'field' and either 'equals' or 'containsAny'.
 * @property containsAny The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
 * @property equals The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
 * @property field The name of the Activity Log event's field that this condition will examine.
 * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
 */
public data class AlertRuleLeafConditionResponse(
    public val containsAny: List<String>? = null,
    public val equals: String? = null,
    public val `field`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.AlertRuleLeafConditionResponse):
            AlertRuleLeafConditionResponse = AlertRuleLeafConditionResponse(
            containsAny = javaType.containsAny().map({ args0 -> args0 }),
            equals = javaType.equals_().map({ args0 -> args0 }).orElse(null),
            `field` = javaType.`field`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
