@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of custom data column.
 * @property name The name of the column.
 * @property type The type of the column data.
 */
public data class ColumnDefinitionResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ColumnDefinitionResponse):
            ColumnDefinitionResponse = ColumnDefinitionResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
