@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Failover configuration on this endpoint. This property is READ-ONLY.
 * @property activeLocation Active location where data flow will occur.
 * @property locations Locations that are configured for failover.
 */
public data class DataCollectionEndpointResponseFailoverConfiguration(
    public val activeLocation: String? = null,
    public val locations: List<LocationSpecResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataCollectionEndpointResponseFailoverConfiguration):
            DataCollectionEndpointResponseFailoverConfiguration =
            DataCollectionEndpointResponseFailoverConfiguration(
                activeLocation = javaType.activeLocation().map({ args0 -> args0 }).orElse(null),
                locations = javaType.locations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.insights.kotlin.outputs.LocationSpecResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
