@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata about the resource
 * @property provisionedBy Azure offering managing this resource on-behalf-of customer.
 * @property provisionedByResourceId Resource Id of azure offering managing this resource on-behalf-of customer.
 */
public data class DataCollectionRuleAssociationResponseMetadata(
    public val provisionedBy: String,
    public val provisionedByResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataCollectionRuleAssociationResponseMetadata):
            DataCollectionRuleAssociationResponseMetadata =
            DataCollectionRuleAssociationResponseMetadata(
                provisionedBy = javaType.provisionedBy(),
                provisionedByResourceId = javaType.provisionedByResourceId(),
            )
    }
}
