@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eventLogs Windows event logs configuration.
 * @property perfCounters Performance counter configuration
 * @property providers ETW providers configuration
 */
public data class DataSourceConfigurationResponse(
    public val eventLogs: List<EventLogConfigurationResponse>? = null,
    public val perfCounters: List<PerformanceCounterConfigurationResponse>? = null,
    public val providers: List<EtwProviderConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DataSourceConfigurationResponse):
            DataSourceConfigurationResponse = DataSourceConfigurationResponse(
            eventLogs = javaType.eventLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EventLogConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            perfCounters = javaType.perfCounters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.PerformanceCounterConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.EtwProviderConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
