@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dimension splitting and filtering definition
 * @property name Name of the dimension
 * @property operator Operator for dimension values
 * @property values List of dimension values
 */
public data class DimensionResponse(
    public val name: String,
    public val `operator`: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DimensionResponse):
            DimensionResponse = DimensionResponse(
            name = javaType.name(),
            `operator` = javaType.`operator`(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
