@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The minimum number of violations required within the selected lookback time window required to raise an alert.
 * @property minFailingPeriodsToAlert The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
 * @property numberOfEvaluationPeriods The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
 */
public data class DynamicThresholdFailingPeriodsResponse(
    public val minFailingPeriodsToAlert: Double,
    public val numberOfEvaluationPeriods: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.DynamicThresholdFailingPeriodsResponse):
            DynamicThresholdFailingPeriodsResponse = DynamicThresholdFailingPeriodsResponse(
            minFailingPeriodsToAlert = javaType.minFailingPeriodsToAlert(),
            numberOfEvaluationPeriods = javaType.numberOfEvaluationPeriods(),
        )
    }
}
